/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchEvaluator;
import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.NightlyBuildStatusDao;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.log.Logger;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class BranchSummary {
    private static final int UNINITIALIZED_STATUS = -999;
    private static Logger log = new Logger(BranchSummary.class.getName());
    private String title;
    private String branch;
    private Date batchStartTime;
    private double threshold;
    private int buildStatus = -999;
    private int evaluatorStatus = -999;
    private List<SuiteSummary> suites = new LinkedList<SuiteSummary>();

    public BranchSummary(String branch, String title, double threshold) throws Exception {
        this.title = title;
        this.branch = branch;
        this.threshold = threshold;
        this.batchStartTime = BatchRunDao.getLastBatchFromPreviousDay(branch);
        Integer status = NightlyBuildStatusDao.getStatus(branch);
        if (status != null) {
            if (status >= 1000) {
                this.evaluatorStatus = status - 1000;
            } else {
                this.evaluatorStatus = 0;
                this.buildStatus = status;
            }
        }
        if (this.batchStartTime != null) {
            List<String> showcases = ShowcaseSpecifier.getValidShowcases(branch, null);
            for (int i = 0; i < showcases.size(); ++i) {
                String showcase = showcases.get(i);
                this.suites.add(new SuiteSummary(showcase, ShowcaseSpecifier.getPrintableShowcaseDescription(showcase)));
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public List<SuiteSummary> getSuites() {
        return this.suites;
    }

    public SuiteSummary getSuiteByName(String showcase) {
        for (int i = 0; i < this.suites.size(); ++i) {
            SuiteSummary suite = this.suites.get(i);
            if (suite.showcase != showcase) continue;
            return suite;
        }
        return null;
    }

    public boolean hasCommits() {
        return this.evaluatorStatus != 10;
    }

    public String getSummaryColor() {
        if (BatchEvaluator.isStatusError(this.evaluatorStatus)) {
            return "red";
        }
        if (this.buildStatus != 0) {
            return "red";
        }
        return "green";
    }

    public String getSummaryStatus() {
        if (BatchEvaluator.isStatusError(this.evaluatorStatus)) {
            return "[BUILD SKIPPED - NOT UPLOADED]";
        }
        if (this.buildStatus != 0) {
            return "[BUILD FAILED! - NOT UPLOADED]";
        }
        return "[UPLOADED]";
    }

    public String getColorForTarget(List<SuiteSummary> suites) {
        for (SuiteSummary summary : suites) {
            if (!(summary.passRatio < this.threshold)) continue;
            return "red";
        }
        return "green";
    }

    public List<SuiteSummary> getSuitesForTarget(List<String> showcases) {
        LinkedList<SuiteSummary> result = new LinkedList<SuiteSummary>();
        for (int i = 0; i < showcases.size(); ++i) {
            SuiteSummary suite = this.getSuiteByName(showcases.get(i));
            if (suite == null) continue;
            result.add(suite);
        }
        return result;
    }

    public List<SuiteSummary> getSuitesForSmartClientTarget() {
        return this.getSuitesForTarget((List<String>)new LinkedList<String>(){
            {
                this.add(null);
                this.add("smartclient");
            }
        });
    }

    public List<SuiteSummary> getSuitesForSmartGwtLgplTarget() {
        return this.getSuitesForTarget((List<String>)new LinkedList<String>(){
            {
                this.add(null);
                this.add("smartclient");
                this.add("smartgwtrunner");
                this.add("smartgwtlgpl");
            }
        });
    }

    public List<SuiteSummary> getSuitesForSmartGwtEeTarget() {
        return this.getSuitesForTarget((List<String>)new LinkedList<String>(){
            {
                this.add(null);
                this.add("smartclient");
                this.add("smartgwtrunner");
                this.add("smartgwtee");
            }
        });
    }

    public class SuiteSummary {
        private String title;
        private String showcase;
        private double passRatio;
        private boolean ran;

        public SuiteSummary(String showcase, String title) throws Exception {
            this.title = title;
            this.showcase = showcase;
            this.ran = BatchRunDao.isStateSuccess(BranchSummary.this.batchStartTime, showcase);
            if (this.ran) {
                this.passRatio = BatchEvaluator.getPassRatio(BranchSummary.this.batchStartTime, showcase, BranchSummary.this.branch);
            }
        }

        public String getTitle() {
            return this.title;
        }

        public String linkify(String text) {
            return Utils.linkify(BranchSummary.this.branch, BranchSummary.this.batchStartTime, this.showcase, null, true, "inherit") + text + "</a>";
        }

        public String getPassPercentage() {
            if (!this.ran) {
                return "[FAILED TO RUN]";
            }
            String html = "[TOO MANY FAILURES]";
            if (this.passRatio >= BranchSummary.this.threshold) {
                int ratio = (int)(100.0 * this.passRatio);
                html = ratio + "%";
            }
            return this.passRatio < 1.0 ? this.linkify(html) : html;
        }

        public String getSuiteColor() {
            if (this.passRatio < BranchSummary.this.threshold) {
                return "red";
            }
            if (this.passRatio < 1.0) {
                return "#EECC00";
            }
            return "green";
        }

        public boolean shouldShowFailureDetails() {
            return this.passRatio < BranchSummary.this.threshold;
        }

        public String getFailureDetails() throws Exception {
            String html = "";
            Date lastGoodTime = BatchRunDao.getLatestPassingBatchStartTime(BranchSummary.this.batchStartTime, this.showcase, BranchSummary.this.branch, BranchSummary.this.threshold);
            double lastGoodRatio = BatchEvaluator.getPassRatio(lastGoodTime, this.showcase, BranchSummary.this.branch);
            String lastGoodAwsId = BatchRunDao.getAwsInstanceId(lastGoodTime);
            html = html + Utils.execCommandAndReturnStdOut(new String[]{"perl", "-MIsomorphic::AutoTest", "-e", "print getCommitReport('" + lastGoodAwsId + "','Last Good','" + this.getSuiteColor() + "',0,', Passed " + (int)(100.0 * lastGoodRatio) + "%')"});
            Date successorTime = BatchRunDao.getSuccessorBatchStartTime(lastGoodTime, BranchSummary.this.branch);
            boolean successorRan = BatchRunDao.isStateSuccess(successorTime, this.showcase);
            String successorAwsId = BatchRunDao.getAwsInstanceId(successorTime);
            String successorRatio = "";
            if (successorRan) {
                successorRatio = ", Passed " + (int)(100.0 * BatchEvaluator.getPassRatio(successorTime, this.showcase, BranchSummary.this.branch)) + "%";
            }
            html = html + Utils.execCommandAndReturnStdOut(new String[]{"perl", "-MIsomorphic::AutoTest", "-e", "print getCommitReport('" + successorAwsId + "','Breaking Commit','" + this.getSuiteColor() + "',1,'" + successorRatio + "')"});
            return html;
        }
    }
}

