/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetailViewParser {
    public static final String DETAIL_PART_RESULT = "result";
    public static final String DETAIL_PART_DESCRIPTION = "description";
    public static final String DETAIL_PART_DETAIL = "detail";
    public static final String RESULTS_ELEMENT_ID = "isc_AutoTest_DetailViewer";

    public static List<Map<String, String>> parse(String html) {
        String detailViewerHtml = DetailViewParser.getDetailViewerHtml(html);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        int currInd = 0;
        while ((currInd = detailViewerHtml.indexOf("class=\"detailBlock\"", currInd)) > 0) {
            int end = detailViewerHtml.indexOf("</table>", currInd);
            String detailBlockHtml = detailViewerHtml.substring(currInd, end);
            int detailItemStart = 0;
            HashMap<String, String> detailData = new HashMap<String, String>();
            while ((detailItemStart = detailBlockHtml.indexOf("<tr>", detailItemStart)) > 0) {
                int detailItemEnd = detailBlockHtml.indexOf("</tr>", detailItemStart);
                String detailItemHtml = detailBlockHtml.substring(detailItemStart, detailItemEnd);
                String key = DetailViewParser.getInnerTextValue(detailItemHtml, "class=\"detailLabel\"", false);
                if (key.endsWith(":")) {
                    key = key.substring(0, key.length() - 1);
                }
                String value = DetailViewParser.getInnerTextValue(detailItemHtml, "class=\"detail\"", true);
                detailData.put(key, value);
                detailItemStart = detailItemEnd;
            }
            result.add(detailData);
            currInd = end;
        }
        return result;
    }

    private static String getInnerTextValue(String blockHtml, String startText, boolean multiline) {
        int block = blockHtml.indexOf(startText);
        if (multiline) {
            int start = blockHtml.indexOf(">", block) + 1;
            int end = blockHtml.lastIndexOf("</td>");
            String text = blockHtml.substring(start, end);
            text = text.replaceAll("\\<br\\>", "\n");
            text = text.replaceAll("\\&nbsp\\;|\\<[^\\>]*\\>", "");
            return text;
        }
        int end = blockHtml.indexOf("</", block);
        int start = blockHtml.lastIndexOf(">", end);
        return blockHtml.substring(start + 1, end);
    }

    public static String getDetailViewerHtml(String html) {
        int detailViewerStartIndex = html.indexOf("eventproxy=\"isc_AutoTest_DetailViewer\"");
        int detailViewerEndIndex = html.indexOf("</div>", detailViewerStartIndex) + 6;
        String detailViewerHtml = html.substring(detailViewerStartIndex, detailViewerEndIndex);
        return detailViewerHtml;
    }
}

