/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.SmartGWTSampleIdMap;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.log.Logger;
import com.thoughtworks.selenium.Selenium;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ShowcaseSpecifier {
    private static Logger log = new Logger(ShowcaseSpecifier.class.getName());
    protected static final String[] possibleShowcases;
    protected static final String[] camelCaseShowcases;
    private ShowcaseSpecifierType m_type;
    private SmartGWTSampleIdMap map;
    private String windowAccessor;

    public ShowcaseSpecifier(String showcase) {
        for (ShowcaseSpecifierType t : ShowcaseSpecifierType.values()) {
            if (!possibleShowcases[t.ordinal()].equals(showcase)) continue;
            this.m_type = t;
            break;
        }
        if (this.m_type == null) {
            this.m_type = ShowcaseSpecifierType.ssSmartClient;
            log.warn((Object)("Unrecognized showcase " + showcase + " found; using " + possibleShowcases[0]));
        }
        switch (this.m_type) {
            case ssSmartClient: 
            case ssSmartGwtRunner: {
                this.windowAccessor = "window";
                break;
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                this.windowAccessor = "window.frames[1].$wnd";
                this.map = new SmartGWTSampleIdMap(this.m_type);
            }
        }
    }

    public boolean isSmartClient() {
        return this.m_type == ShowcaseSpecifierType.ssSmartClient;
    }

    public boolean isSmartGWTEE() {
        return this.m_type == ShowcaseSpecifierType.ssSmartGwtEE;
    }

    public boolean isSmartGWTRunner() {
        return this.m_type == ShowcaseSpecifierType.ssSmartGwtRunner;
    }

    public String getExampleOpenShowcase() {
        switch (this.m_type) {
            case ssSmartClient: {
                return "smartclient";
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                return "smartgwt";
            }
        }
        return null;
    }

    public String getShowcaseSpecificId(String smartClientId) {
        switch (this.m_type) {
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                return this.map.getSGWTIdFromSmartClientId(smartClientId);
            }
        }
        return smartClientId;
    }

    public String getExampleTreeScLocator() {
        String result = "scLocator=//";
        switch (this.m_type) {
            case ssSmartClient: {
                result = result + "FeatureExplorer[ID='featureExplorer']/exampleTree";
                break;
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                result = result + "TreeGrid[ID='isc_SideNavTree_0']";
            }
        }
        return result;
    }

    public String getExampleTreeObject() {
        switch (this.m_type) {
            case ssSmartClient: {
                return this.windowAccessor + ".featureExplorer_exampleTree";
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                return this.windowAccessor + ".isc_SideNavTree_0";
            }
        }
        return null;
    }

    public String getShowcaseObject() {
        switch (this.m_type) {
            case ssSmartClient: {
                return this.windowAccessor + ".featureExplorer_exampleViewer";
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                return this.windowAccessor + ".isc_Showcase_1_0";
            }
        }
        return null;
    }

    public String getSeleniumScriptFilter() {
        String rcTestSuffix = "\\.rctest\\.html$";
        switch (this.m_type) {
            case ssSmartClient: 
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                return "/[^.]*" + rcTestSuffix;
            }
            case ssSmartGwtRunner: {
                return "/[^.]*Test\\.java$";
            }
        }
        return null;
    }

    public String getNextTestCallback() {
        switch (this.m_type) {
            case ssSmartGwtRunner: {
                return this.windowAccessor + ".isc.runNextTest()";
            }
        }
        return null;
    }

    public String getTestCompleteCallback() {
        switch (this.m_type) {
            case ssSmartGwtRunner: {
                return this.windowAccessor + ".isc.testComplete()";
            }
        }
        return null;
    }

    public boolean shouldTestExampleTreeNode(Selenium selenium, int row) {
        String rec = this.getExampleTreeObject() + ".getRecord(" + row + ")";
        if (Utils.evalAsBoolean(selenium, rec + ".testDisabled")) {
            return false;
        }
        boolean isFolder = Utils.evalAsBoolean(selenium, this.getExampleTreeObject() + ".data.isFolder(" + rec + ")");
        switch (this.m_type) {
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                isFolder |= Utils.evalAsBoolean(selenium, rec + ".factory == null");
            }
        }
        return !isFolder;
    }

    public boolean isExampleTreeNodeANormalExample(Selenium selenium, int row) {
        String rec = this.getExampleTreeObject() + ".getRecord(" + row + ")";
        return !this.getBooleanFieldFromRecord(selenium, rec, "iframe") && !this.getBooleanFieldFromRecord(selenium, rec, "external") && !this.getBooleanFieldFromRecord(selenium, rec, "fullScreen");
    }

    protected String getDefaultShowcaseFile() {
        switch (this.m_type) {
            case ssSmartClient: {
                return "SmartClient_Explorer.html";
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                return "index.html";
            }
            case ssSmartGwtRunner: {
                return "TestRunnerApp.jsp";
            }
        }
        return "";
    }

    protected String getDefaultShowcaseRoot() {
        switch (this.m_type) {
            case ssSmartClient: {
                return "/isomorphic/system/reference";
            }
        }
        return "";
    }

    public void clearExampleResultsViewer(Selenium selenium) {
        String destroyCall = this.getShowcaseObject();
        switch (this.m_type) {
            case ssSmartClient: {
                destroyCall = destroyCall + ".exampleClearResult()";
                break;
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                destroyCall = destroyCall + ".destroySampleResultsManager()";
            }
        }
        Utils.getEvalWithTry(selenium, destroyCall);
    }

    public void clearRPCManagerState(Selenium selenium) {
        selenium.getEval(this.windowAccessor + ".isc.RPCManager.queueSent = null");
    }

    public boolean mustReloadExampleTree(TestCaseResults tcr) {
        boolean result = tcr.isTimeoutError();
        switch (this.m_type) {
            case ssSmartClient: 
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                result |= !tcr.allTestsSuccessful();
            }
        }
        return result;
    }

    private String getFieldFromRecord(Selenium selenium, String record, String field) {
        String getFieldFromRecordScript;
        String value = selenium.getEval(record + "." + field);
        if (!value.equals("null")) {
            return value;
        }
        String ref = selenium.getEval(record + ".ref");
        if (!ref.equals("null") && !(value = selenium.getEval(getFieldFromRecordScript = "var node = " + this.getExampleTreeObject() + ".data.findById('" + ref + "'); !node ? null : node." + field)).equals("null")) {
            return value;
        }
        return null;
    }

    private boolean getBooleanFieldFromRecord(Selenium selenium, String record, String field) {
        String valueAsString = this.getFieldFromRecord(selenium, record, field);
        return valueAsString != null ? valueAsString.toLowerCase().equals("true") : false;
    }

    protected TestSpecifier generateTestSpecifier(Selenium selenium, int row) {
        String record = this.getExampleTreeObject() + ".getRecord(" + row + ")";
        String locator = this.getExampleTreeScLocator() + "/body/row[" + row + "]/col[0]";
        String id = null;
        String url = null;
        switch (this.m_type) {
            case ssSmartClient: {
                id = this.getFieldFromRecord(selenium, record, "id");
                if (null != this.getFieldFromRecord(selenium, record, "ref")) {
                    return null;
                }
                url = this.getFieldFromRecord(selenium, record, "jsURL");
                if (null == url) {
                    url = this.getFieldFromRecord(selenium, record, "xmlURL");
                }
                if (null != url) break;
                url = this.getFieldFromRecord(selenium, record, "url");
                break;
            }
            case ssSmartGwtEE: 
            case ssSmartGwtLGPL: {
                String className;
                id = this.getFieldFromRecord(selenium, record, "nodeID");
                if (null != id) {
                    if (id.endsWith("-new") || id.endsWith("_new")) {
                        return null;
                    }
                    String smartClientId = this.map.getSmartClientIdFromSGWTId(id);
                    String string = id = smartClientId == null ? "[" + id + "]" : smartClientId;
                }
                if (null == (className = this.getFieldFromRecord(selenium, record, "sampleClassName"))) break;
                url = className.replaceAll("\\.", "/");
            }
        }
        return url != null ? new TestSpecifier(id, url, locator) : null;
    }

    protected Map<String, List<String>> getSeleniumHTMLScripts(String testRootPath, String[] seleniumScripts) {
        TestRunnerLauncher launcher = (TestRunnerLauncher)TestRunner.getConfiguration();
        List<String> files = launcher.getTestScripts(seleniumScripts, this.getSeleniumScriptFilter(), testRootPath);
        HashMap<String, List<String>> testMap = new HashMap<String, List<String>>();
        for (String path : files) {
            String id = path.replaceAll("^.*[/\\\\]", "").replaceAll("[-_.](.)+$", "");
            if (id.length() <= 0 || null != this.map && !this.map.isSmartClientIdInMapRange(id)) continue;
            ArrayList<String> tests = (ArrayList<String>)testMap.get(id);
            if (tests == null) {
                tests = new ArrayList<String>();
                testMap.put(id, tests);
            }
            tests.add(path);
        }
        return testMap;
    }

    protected static String[] getServerLogs(Selenium selenium, ShowcaseSpecifier showcase, int testNumber) {
        if (ShowcaseSpecifier.isTestRunnerBased(showcase)) {
            TestRunnerConfiguration config = TestRunner.getConfiguration();
            String jsQuery = "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner; var logs = runner.getServerLogs(" + (testNumber - 1) + ");";
            String jsResult = Utils.getEvalWithTry(selenium, "try { " + jsQuery + "logs.length } catch (e) { 0 }");
            int nLogs = 0;
            try {
                nLogs = Integer.parseInt(jsResult);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (nLogs > 0) {
                String[] logs = new String[nLogs];
                for (int i = 0; i < nLogs; ++i) {
                    logs[i] = Utils.getEvalWithTry(selenium, jsQuery + "logs[" + i + "]");
                }
                return logs;
            }
        }
        return null;
    }

    protected static String getLastShowcase() {
        return possibleShowcases[possibleShowcases.length - 1];
    }

    protected static boolean isShowcaseValid(String showcase) {
        return Arrays.asList(possibleShowcases).contains(showcase);
    }

    protected static String getShowcaseAsCamelCase(String showcase, String noMatch) {
        for (int i = 0; i < camelCaseShowcases.length; ++i) {
            if (!possibleShowcases[i].equals(showcase)) continue;
            return camelCaseShowcases[i];
        }
        return noMatch;
    }

    protected static String getPrintableShowcaseDescription(String showcase) {
        for (int i = 0; i < camelCaseShowcases.length; ++i) {
            if (!possibleShowcases[i].equals(showcase)) continue;
            ShowcaseSpecifierType specifier = ShowcaseSpecifierType.values()[i];
            switch (specifier) {
                case ssSmartClient: {
                    return "SC Feature Explorer";
                }
                case ssSmartGwtLGPL: {
                    return "SGWT LGPL Showcase";
                }
                case ssSmartGwtEE: {
                    return "SGWT Pro/EE Showcase";
                }
                case ssSmartGwtRunner: {
                    return "SGWT AutoTests";
                }
            }
        }
        return "SC AutoTests";
    }

    protected static String getPartialReportForTimedoutTest(Selenium selenium, ShowcaseSpecifier specifier) {
        String javaScript = "selenium.browserbot.getCurrentWindow().isc.TestRunner.getUnassignedErrorDetails()";
        if (specifier != null) {
            switch (specifier.m_type) {
                case ssSmartClient: {
                    javaScript = specifier.getShowcaseObject() + ".exampleErrorDetails";
                    break;
                }
                case ssSmartGwtEE: 
                case ssSmartGwtLGPL: {
                    javaScript = specifier.getShowcaseObject() + ".getDetailsReport()";
                    break;
                }
                case ssSmartGwtRunner: {
                    javaScript = null;
                }
            }
        }
        String partialReport = "";
        if (javaScript != null && (partialReport = Utils.getEvalWithTry(selenium, javaScript)).length() > 0) {
            partialReport = " / Possible Cause: " + partialReport;
        }
        return partialReport;
    }

    protected static List<String> getValidShowcases(String branch, Date batchStartTime) {
        String status;
        if (Utils.compareBranches(branch, "ISC_SC81_BRANCH") <= 0) {
            return new LinkedList<String>();
        }
        LinkedList<String> showcases = new LinkedList<String>(){
            {
                this.add(null);
            }
        };
        if (batchStartTime != null && Utils.matchRegExp("/^wrath.*Failure$/", status = BatchRunDao.getBatchProperty(batchStartTime, "completionStatus"))) {
            return showcases;
        }
        if (Utils.compareBranches(branch, "ISC_83_BRANCH") >= 0) {
            showcases.add("smartclient");
            showcases.add("smartgwtlgpl");
            showcases.add("smartgwtee");
        }
        if (Utils.compareBranches(branch, "ISC_90_BRANCH") >= 0) {
            showcases.add("smartgwtrunner");
        }
        return showcases;
    }

    protected static String getShowcaseAsUrlParameter(String showcase) {
        return showcase != null ? showcase : "dottest";
    }

    protected static boolean isTestRunnerBased(String showcase) {
        return showcase == null || showcase.equalsIgnoreCase("smartgwtrunner");
    }

    protected static boolean isTestRunnerBased(ShowcaseSpecifier showcase) {
        return showcase == null || showcase.isSmartGWTRunner();
    }

    static {
        camelCaseShowcases = new String[]{"smartClient", "smartGwtLgpl", "smartGwtEe", "smartGwtRunner"};
        int nShowcases = camelCaseShowcases.length;
        possibleShowcases = new String[nShowcases];
        for (int i = 0; i < nShowcases; ++i) {
            ShowcaseSpecifier.possibleShowcases[i] = camelCaseShowcases[i].toLowerCase();
        }
    }

    protected static enum ShowcaseSpecifierType {
        ssSmartClient,
        ssSmartGwtLGPL,
        ssSmartGwtEE,
        ssSmartGwtRunner;

    }
}

