/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.Utils;
import com.isomorphic.log.Logger;
import com.thoughtworks.selenium.DefaultSelenium;

public class TestRunnerSelenium
extends DefaultSelenium {
    private static Logger log = new Logger(TestRunnerSelenium.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private boolean browserMaximized;

    public TestRunnerSelenium(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        super(serverHost, serverPort, browserStartCommand, browserURL);
    }

    public void start() {
        super.start();
        this.browserMaximized = false;
        int timeout = TestRunner.getConfiguration().getSeleniumTimeout();
        this.setTimeout(Integer.toString(timeout * 1000));
    }

    public void captureScreenshot(String filename) {
        Utils.sleep(3000);
        super.captureScreenshot(filename);
    }

    public void grab() {
        this.captureScreenshot(tmpDir + "/browser-final.png");
        try {
            Runtime.getRuntime().exec("timeout 60 showFirefoxBrowserConsole.sh").waitFor();
        }
        catch (Exception e) {
            log.error((Object)"Hit exception while trying to take screen shot", (Throwable)e);
        }
        this.captureScreenshot(tmpDir + "/error-console.png");
    }

    public boolean getBrowserMaximized() {
        return this.browserMaximized;
    }

    public void setBrowserMaximized(boolean maximized) {
        this.browserMaximized = maximized;
    }
}

