/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.tools.DataImport;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OfficeSupplyImport
extends Base {
    private static Logger log = new Logger(OfficeSupplyImport.class.getName());

    public static void main(String[] argv) throws Exception {
        DataImport importer = new DataImport(1, "\t");
        List origRows = importer.importToRows(new FileReader("officeSupplyData.txt"));
        List categoryProperties = DataTools.arrayToList((Object[])new String[]{"LEV-A", "LEV-B", "LEV-C", "LEV-D", "LEV-E", "CALevE"});
        List unusedProperties = DataTools.arrayToList((Object[])new String[]{"LEV-A", "LEV-B", "LEV-C", "LEV-D", "LEV-E", "CALevE", "minimumOrder", "catalogPage", "itemRef", "Manufacturer"});
        String lastTopCategory = "Misc";
        HashMap<String, Map> categories = new HashMap<String, Map>();
        HashMap categoryCounts = new HashMap();
        ArrayList<Map> rows = new ArrayList<Map>();
        for (Map row : origRows) {
            if (row.get("itemName") == null) continue;
            if (row.get("LEV-A") != null) {
                lastTopCategory = (String)row.get("LEV-A");
            }
            String lastCategoryName = lastTopCategory;
            for (int level = 0; level < 3; ++level) {
                String categoryName;
                String categoryProperty = (String)categoryProperties.get(level);
                if (!row.containsKey(categoryProperty) || (categoryName = (String)row.get(categoryProperty)) == null) continue;
                Map categoryRow = (Map)categories.get(categoryName);
                if (categoryRow == null) {
                    categoryRow = DataTools.buildMap((Object)"category", (Object)categoryName, (Object)"itemName", (Object)categoryName, (Object)"isCategory", (Object)new Boolean(true));
                    categoryRow.put("parentID", level == 0 ? "root" : lastCategoryName);
                    categories.put(categoryName, categoryRow);
                    rows.add(categoryRow);
                }
                lastCategoryName = categoryName;
            }
            int categoryCount = DataTools.getIntInMap(categoryCounts, (Object)lastCategoryName);
            if (categoryCount < 120) {
                row.put("parentID", lastCategoryName);
                row.put("category", lastCategoryName);
                row.put("isCategory", new Boolean(false));
                rows.add(row);
                DataTools.incrementIntInMap(categoryCounts, (Object)lastCategoryName);
            }
            for (String unusedProperty : unusedProperties) {
                if (!row.containsKey(unusedProperty)) continue;
                row.remove(unusedProperty);
            }
        }
        log.warn((Object)("Categories: " + DataTools.prettyPrint(categories)));
        FileWriter out = new FileWriter("supplyItemTree.data.xml");
        out.write("<List>\n");
        for (Map row : rows) {
            XML.recordToXML((String)"supplyItemTree", (Map)row, (Writer)out, (boolean)false, null);
            out.write("\n");
        }
        out.write("</List>");
        out.flush();
    }
}

