/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.contentexport;

import com.isomorphic.base.Base;
import com.isomorphic.contentexport.B64ImgReplacedElementFactory;
import com.isomorphic.contentexport.ResourceLoader;
import com.isomorphic.contentexport.SvgImage;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.IPdfExporter;
import com.isomorphic.rpc.RPCManager;
import com.lowagie.text.pdf.codec.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PdfExport
extends Base
implements IPdfExporter {
    public void getPdfObject(String html, Map settings, HttpServletResponse response, RPCManager rpc) throws Exception {
        ITextRenderer renderer = this.getPdfRenderer(html, settings);
        rpc.doCustomResponse();
        String pdfName = settings.get("pdfName") == null ? "export" : settings.get("pdfName").toString();
        response.addHeader("content-disposition", "attachment;filename=" + pdfName + ".pdf");
        response.setContentType("application/pdf");
        ServletOutputStream os = response.getOutputStream();
        renderer.createPDF((OutputStream)os);
        os.close();
        os = null;
    }

    public ITextRenderer getPdfRenderer(String html, Map settings) throws Exception {
        int posLastIndex;
        String extraStyleSheet;
        Logger log = new Logger(PdfExport.class.getName());
        StringBuilder htmlFinal = new StringBuilder();
        String charSet = config.get((Object)"contentExport.charset") == null ? "UTF-8" : config.get((Object)"contentExport.charset").toString();
        log.info((Object)("CharSet used: " + charSet));
        String skinName = settings.get("skinName") == null ? "" : settings.get("skinName").toString();
        String dirSkin = "";
        String webRoot = config.get((Object)"webRoot").toString();
        if (config.get((Object)("skin." + skinName + ".location")) == null) {
            if (skinName.equalsIgnoreCase("")) {
                String[] parts = settings.get("defaultSkinName").toString().split("/");
                skinName = parts[parts.length - 1];
            }
            dirSkin = webRoot + "/" + config.get((Object)"isomorphicPathRootRelative").toString() + "/skins/" + skinName + "/";
        } else {
            dirSkin = webRoot + "/" + config.get((Object)("skin." + skinName + ".location")).toString() + "/";
        }
        String pathExtraStyleSheet = "";
        String nameExtraStyleSheet = "";
        ArrayList<String> extraResources = new ArrayList<String>();
        if (config.get((Object)("skin." + skinName + ".extraStyleSheet")) != null) {
            extraStyleSheet = config.get((Object)"webRoot").toString() + "/" + config.get((Object)("skin." + skinName + ".extraStyleSheet")).toString();
            posLastIndex = extraStyleSheet.lastIndexOf("/");
            pathExtraStyleSheet = extraStyleSheet.substring(0, posLastIndex + 1);
            nameExtraStyleSheet = extraStyleSheet.substring(posLastIndex + 1, extraStyleSheet.length());
        }
        htmlFinal.append("<html>");
        htmlFinal.append("<head>");
        htmlFinal.append("<meta HTTP-EQUIV='Content-Type' content='text/html; charset=" + charSet + "'/>");
        htmlFinal.append("<link type='text/css' rel='stylesheet' href='skin_styles.css'/>");
        if (!pathExtraStyleSheet.equalsIgnoreCase("")) {
            extraResources.add(pathExtraStyleSheet);
            htmlFinal.append("<link type='text/css' rel='stylesheet' href='" + nameExtraStyleSheet + "'/>");
        }
        pathExtraStyleSheet = "";
        extraStyleSheet = (String)settings.get("externalStylesheet");
        if (extraStyleSheet != null) {
            posLastIndex = extraStyleSheet.lastIndexOf("/");
            pathExtraStyleSheet = extraStyleSheet.substring(0, posLastIndex + 1);
            nameExtraStyleSheet = extraStyleSheet.substring(posLastIndex + 1, extraStyleSheet.length());
        }
        if (!pathExtraStyleSheet.equalsIgnoreCase("")) {
            extraResources.add(pathExtraStyleSheet);
            htmlFinal.append("<link type='text/css' rel='stylesheet' href='" + nameExtraStyleSheet + "'/>");
        }
        if (settings.get("exportCSS") != null) {
            htmlFinal.append("<style>");
            htmlFinal.append((String)settings.get("exportCSS"));
            htmlFinal.append("</style>");
        }
        htmlFinal.append("</head>");
        htmlFinal.append("<body>");
        html = this.convertAllSvgOccurrencesToBase64(log, html);
        htmlFinal.append(html);
        htmlFinal.append("</body>");
        htmlFinal.append("</html>");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printErr = new PrintWriter(stringWriter);
        Tidy tidy = new Tidy();
        tidy.setInputEncoding(charSet);
        tidy.setOutputEncoding(charSet);
        tidy.setErrout(printErr);
        Document doc = tidy.parseDOM((Reader)new StringReader(htmlFinal.toString()), null);
        ITextRenderer renderer = new ITextRenderer();
        ResourceLoader callback = new ResourceLoader(renderer.getOutputDevice(), dirSkin, extraResources, renderer.getFontResolver());
        callback.setSharedContext(renderer.getSharedContext());
        renderer.getSharedContext().setUserAgentCallback((UserAgentCallback)callback);
        B64ImgReplacedElementFactory factory = new B64ImgReplacedElementFactory(renderer.getOutputDevice());
        renderer.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)factory);
        renderer.setDocument(doc, null);
        renderer.layout();
        printErr.flush();
        printErr.close();
        return renderer;
    }

    private String convertAllSvgOccurrencesToBase64(Logger log, String html) throws IOException {
        int startIndex = html.indexOf("<svg");
        while (startIndex >= 0) {
            int endIndex = -1;
            int nestLevel = 1;
            int ltPos = html.indexOf(60, startIndex + 1);
            while (ltPos != -1 && ltPos + "/svg>".length() < html.length()) {
                assert (html.charAt(ltPos) == '<');
                char c = html.charAt(ltPos + 1);
                if (c == '/') {
                    if (html.charAt(ltPos + 2) == 's' && html.charAt(ltPos + 3) == 'v' && html.charAt(ltPos + 4) == 'g' && html.charAt(ltPos + 5) == '>' && --nestLevel == 0) {
                        endIndex = ltPos + "</svg>".length();
                        break;
                    }
                } else if (c == 's' && html.charAt(ltPos + 2) == 'v' && html.charAt(ltPos + 3) == 'g') {
                    ++nestLevel;
                }
                ltPos = html.indexOf(60, ltPos + 1);
            }
            if (endIndex < 0) {
                throw new IOException("No closing `svg` tag was found corresponding to an opening `svg` tag.");
            }
            String svgToConvert = html.substring(startIndex, endIndex);
            log.debug((Object)"svgToConvert", (Object)svgToConvert);
            String imgHtml = this.convertSvgImages(svgToConvert);
            StringBuilder result = new StringBuilder(html.substring(0, startIndex));
            result.append(imgHtml);
            result.append(html.substring(endIndex));
            html = result.toString();
            startIndex = html.indexOf("<svg", startIndex + imgHtml.length());
        }
        return html;
    }

    private String convertSvgImages(String svgString) throws IOException {
        SvgImage img = new SvgImage(svgString);
        BufferedImage res = img.createImage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)res, "png", baos);
        String encodedImage = Base64.encodeBytes((byte[])baos.toByteArray());
        return "<img src='data:image/png;base64," + encodedImage + "' width='" + res.getWidth() + "' height='" + res.getHeight() + "' style='border:0px;max-width:100%'>";
    }
}

