/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.collections;

import org.apache.commons.collections.UnboundedFifoBuffer;

public class BlockingQueue {
    UnboundedFifoBuffer queue;

    public BlockingQueue() {
        this.queue = new UnboundedFifoBuffer();
    }

    public BlockingQueue(int size) {
        this.queue = new UnboundedFifoBuffer(size);
    }

    public synchronized boolean add(Object o) {
        try {
            this.queue.add(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notify();
        return true;
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized Object get() {
        return this.get(0L);
    }

    public synchronized Object get(long timeout) {
        Object o;
        while ((o = this.getNonBlocking()) == null) {
            try {
                this.wait(timeout);
                return this.getNonBlocking();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return o;
    }

    public synchronized Object getNonBlocking() {
        try {
            return this.queue.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized Object remove() {
        return this.remove(0L);
    }

    public synchronized Object remove(long timeout) {
        Object o;
        while ((o = this.removeNonBlocking()) == null) {
            try {
                this.wait(timeout);
                return this.removeNonBlocking();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return o;
    }

    public synchronized Object removeNonBlocking() {
        try {
            return this.queue.remove();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

