/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSFileSpec {
    private static Logger log = new Logger(DSFileSpec.class.getName());
    protected String dsName;
    protected String dsFileName;
    protected String dsFileType;
    protected String dsFileFormat;
    private DataSource ds;
    protected String cachedURL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() throws Exception {
        if (this.ds == null) {
            DataStructCache.disableDsPaths();
            try {
                this.ds = DataSourceManager.getDataSource(this.dsName);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DataStructCache.enableDsPaths();
                throw throwable;
            }
            DataStructCache.enableDsPaths();
            {
            }
        }
        return this.ds;
    }

    private void freeDataSource() {
        DataSourceManager.freeDataSource(this.ds);
        this.ds = null;
    }

    public DSFileSpec(String dsName, String dsFileName) {
        this.dsName = dsName;
        this.dsFileName = dsFileName;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType) {
        this(dsName, dsFileName);
        this.dsFileType = dsFileType;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType, String dsFileFormat) {
        this(dsName, dsFileName, dsFileType);
        this.dsFileFormat = dsFileFormat;
    }

    public DSFileSpec(Map<String, String> record) {
        this.dsFileName = record.get("fileName");
        this.dsFileType = record.get("fileType");
        this.dsFileFormat = record.get("fileFormat");
    }

    public DSFileSpec(String url) {
        String fullPath;
        String remainder;
        if (url.startsWith("ds://")) {
            remainder = StringUtils.removeStart((String)url, (String)"ds://");
            this.dsName = StringUtils.substringBefore((String)remainder, (String)"/");
            fullPath = StringUtils.substringAfter((String)remainder, (String)"/");
        } else if (url.startsWith("ds:/")) {
            remainder = StringUtils.removeStart((String)url, (String)"ds:/");
            this.dsName = StringUtils.substringBefore((String)remainder, (String)"/");
            fullPath = StringUtils.substringAfter((String)remainder, (String)"/");
        } else {
            fullPath = url;
        }
        String onlyFileName = StringUtils.substringAfterLast((String)fullPath, (String)"/");
        if ("".equals(onlyFileName) || onlyFileName == null) {
            onlyFileName = fullPath;
        }
        String[] tokens = StringUtils.split((String)onlyFileName, (char)'.');
        int length = tokens.length;
        switch (length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (tokens[1].contains(" ")) break;
                this.dsFileType = tokens[1];
                break;
            }
            default: {
                this.dsFileType = tokens[length - 2];
                this.dsFileFormat = tokens[length - 1];
                if (this.dsFileFormat.contains(" ")) {
                    this.dsFileType = null;
                    this.dsFileFormat = null;
                    break;
                }
                if (!this.dsFileType.contains(" ")) break;
                this.dsFileType = this.dsFileFormat;
                this.dsFileFormat = null;
            }
        }
        this.dsFileName = fullPath;
        if (this.dsFileFormat != null) {
            this.dsFileName = StringUtils.removeEnd((String)this.dsFileName, (String)("." + this.dsFileFormat));
        }
        if (this.dsFileType != null) {
            this.dsFileName = StringUtils.removeEnd((String)this.dsFileName, (String)("." + this.dsFileType));
        }
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setDataSourceName(String name) {
        this.dsName = name;
        this.markDirty();
    }

    public String getFileName() {
        return this.dsFileName;
    }

    public void setFileName(String name) {
        this.dsFileName = name;
        this.markDirty();
    }

    public String getFileType() {
        return this.dsFileType;
    }

    public void setFileType(String type) {
        this.dsFileType = type;
        this.markDirty();
    }

    public String getFileFormat() {
        return this.dsFileFormat;
    }

    public void setFileFormat(String format) {
        this.dsFileFormat = format;
        this.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        try {
            List<Map<String, Object>> results = this.getDataSource().removeFile(this);
            boolean bl = results != null && results.size() > 0;
            Object var4_5 = null;
            this.freeDataSource();
            return bl;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                boolean bl = false;
                Object var4_6 = null;
                this.freeDataSource();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        try {
            boolean bl = this.getDataSource().hasFile(this);
            Object var4_3 = null;
            this.freeDataSource();
            return bl;
        }
        catch (Exception ex) {
            try {
                boolean bl = false;
                Object var4_4 = null;
                this.freeDataSource();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getReader() {
        try {
            Reader reader = this.getDataSource().getFile(this);
            Object var4_3 = null;
            this.freeDataSource();
            return reader;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                Reader reader = null;
                Object var4_4 = null;
                this.freeDataSource();
                return reader;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        try {
            InputStream inputStream = this.getDataSource().getFileAsInputStream(this);
            Object var4_3 = null;
            this.freeDataSource();
            return inputStream;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                InputStream inputStream = null;
                Object var4_4 = null;
                this.freeDataSource();
                return inputStream;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        try {
            long l = this.getDataSource().getFileSize(this);
            Object var5_3 = null;
            this.freeDataSource();
            return l;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                long l = -1L;
                Object var5_4 = null;
                this.freeDataSource();
                return l;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        try {
            long l = this.getDataSource().getFileLastModified(this);
            Object var5_3 = null;
            this.freeDataSource();
            return l;
        }
        catch (Exception ex) {
            try {
                log.warn(ex.toString());
                long l = 0L;
                Object var5_4 = null;
                this.freeDataSource();
                return l;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.freeDataSource();
                throw throwable;
            }
        }
    }

    public boolean setLastModified(long time) {
        return true;
    }

    protected void markDirty() {
        this.cachedURL = null;
    }

    public Map<String, Object> getPrimaryKeys() {
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        String fileName = this.getFileName();
        String fileType = this.getFileType();
        String fileFormat = this.getFileFormat();
        if (fileName != null) {
            primaryKeys.put("fileName", fileName);
        }
        if (fileType != null) {
            primaryKeys.put("fileType", fileType);
        }
        if (fileFormat != null) {
            primaryKeys.put("fileFormat", fileFormat);
        }
        return primaryKeys;
    }

    public String toString() {
        if (this.cachedURL == null) {
            this.cachedURL = "ds://" + this.dsName + "/" + this.dsFileName;
            if (this.dsFileType != null) {
                this.cachedURL = this.cachedURL + "." + this.dsFileType;
            }
            if (this.dsFileFormat != null) {
                this.cachedURL = this.cachedURL + "." + this.dsFileFormat;
            }
        }
        return this.cachedURL;
    }
}

