/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCDMI;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;

public class SCUploadSaveFileDataSource
extends BasicDataSource {
    private static final long serialVersionUID = -4704649403493285140L;
    private static Logger log = new Logger(SCUploadSaveFileDataSource.class.getName());

    public DSResponse executeAdd(DSRequest req) throws Exception {
        RPCDMI.verifyMethodEnabled("saveFile");
        Object fileContents = req.getCriteria().get("file");
        String fileContentsAsString = null;
        if (fileContents instanceof String) {
            fileContentsAsString = (String)fileContents;
        } else {
            InputStream fileInputStream = (InputStream)req.getCriteria().get("file");
            fileContentsAsString = IOUtil.inputStreamToString(fileInputStream);
        }
        String fileName = (String)req.getCriteria().get("file_filename");
        String fileDir = (String)req.getCriteria().get("file_dir");
        String filePath = fileDir + "/" + fileName;
        String serverFilePath = BuiltinRPC.validateFilePath(filePath, "saveFile");
        DSResponse dsResponse = new DSResponse(this);
        long lastModified = new Date().getTime();
        if (!filePath.startsWith("[READ_ONLY]")) {
            BuiltinRPC.saveFile(serverFilePath, fileContentsAsString);
            ISCFile f = new ISCFile(serverFilePath);
            lastModified = f.lastModified();
        }
        Map data = DataTools.buildMap("file_filename", fileName, "file", fileContentsAsString, "path", filePath, "file_date_created", lastModified);
        dsResponse.setData(data);
        dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
        return dsResponse;
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        if ("checkUploadFeature".equals(req.getOperationId())) {
            DSResponse dsResponse = new DSResponse(this);
            boolean allowed = false;
            try {
                RPCDMI.verifyMethodEnabled("saveFile");
                BuiltinRPC.validateFileDir("[READ_ONLY]", "saveFile");
                allowed = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            dsResponse.setStatus(allowed ? DSResponse.STATUS_SUCCESS : DSResponse.STATUS_FAILURE);
            return dsResponse;
        }
        return super.executeCustom(req);
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        RPCDMI.verifyMethodEnabled("loadFile");
        String filePath = (String)req.getCriteria().get("path");
        String serverFilePath = BuiltinRPC.validateFilePath(filePath, "loadFile");
        DSResponse dsResponse = new DSResponse(this);
        ISCFile f = new ISCFile(serverFilePath);
        if (!f.exists()) {
            dsResponse.setStatus(DSResponse.STATUS_FAILURE);
            return dsResponse;
        }
        String fileName = filePath;
        if (fileName.indexOf("/") != -1) {
            fileName = fileName.substring(fileName.lastIndexOf("/"), fileName.length());
        }
        String fileContentsAsString = f.getAsString();
        Map data = DataTools.buildMap("file_filename", fileName, "file", fileContentsAsString, "path", filePath, "file_date_created", f.lastModified());
        dsResponse.setData(data);
        dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
        return dsResponse;
    }
}

