/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ExcelDataExport;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class DataExport
extends Base {
    private static Logger log = new Logger(DataExport.class.getName());
    protected static JSTranslater jsTrans = new JSTranslater();
    protected List<String> order;
    protected int outputType;
    protected int lineBreakStyle = 4;
    protected String lineBreak = System.getProperty("line.separator");
    protected DataSource dataSource;
    public static final int CSV = 1;
    public static final int JS_LITERAL = 2;
    public static final int XML = 3;
    public static final int XLS = 4;
    public static final int OOXML = 5;
    public static final int PNG = 101;
    public static final int JPEG = 102;
    public static final int DEFAULT_OUTPUT = 1;
    protected String exportDelimiter = ",";
    public static final int MAC_LINEBREAK = 1;
    public static final int UNIX_LINEBREAK = 2;
    public static final int DOS_LINEBREAK = 3;
    public static final int DEFAULT_LINEBREAK = 4;
    protected String header;
    protected boolean headerless;
    protected String footer;
    protected Map settings;
    protected boolean exportRawValues;
    public String currencySymbol = "$";
    protected Map<String, SimpleDateFormat> dateFormatCache = new HashMap<String, SimpleDateFormat>();
    protected Map<String, DecimalFormat> numberFormatCache = new HashMap<String, DecimalFormat>();

    public static DataExport getDataExport(Map settings) throws Exception {
        return DataExport.getDataExport(settings, null);
    }

    public static DataExport getDataExport(Map settings, DSRequest dsRequest) throws Exception {
        DataExport dataExport = new DataExport();
        if (settings != null) {
            Object dsObj;
            dataExport.settings = settings;
            if (settings.get("exportAs") instanceof String) {
                dataExport.outputType = DataExport.getFormatIdForFormat(((String)settings.get("exportAs")).toLowerCase());
            }
            if (settings.get("lineBreakStyle") instanceof String) {
                dataExport.lineBreakStyle = DataExport.getLineBreakStyleIdForLineBreakStyle(((String)settings.get("lineBreakStyle")).toLowerCase());
                dataExport.lineBreak = DataExport.getLineBreakForLineBreakStyle(((String)settings.get("lineBreakStyle")).toLowerCase());
            }
            dataExport.order = (List)settings.get("exportFields");
            dataExport.exportDelimiter = (String)settings.get("exportDelimiter");
            if (dataExport.exportDelimiter == null || dataExport.exportDelimiter.equals("")) {
                dataExport.exportDelimiter = ",";
            }
            if ((dsObj = settings.get("dataSource")) instanceof DataSource) {
                dataExport.dataSource = (DataSource)dsObj;
            } else if (dsObj != null) {
                dataExport.dataSource = DataSourceManager.get((String)dsObj, dsRequest);
            }
            dataExport.header = (String)settings.get("exportHeader");
            dataExport.headerless = DataTools.asBoolean(settings.get("exportHeaderless"), false);
            dataExport.footer = (String)settings.get("exportFooter");
            dataExport.exportRawValues = DataTools.asBoolean(settings.get("exportRawValues"), false);
            Object exportCurrencySymbol = settings.get("exportCurrencySymbol");
            if (exportCurrencySymbol != null) {
                dataExport.currencySymbol = (String)exportCurrencySymbol;
            }
        }
        return dataExport;
    }

    public static int getFormatIdForFormat(String format) {
        int formatId = format.equals("json") ? 2 : (format.equals("xml") ? 3 : (format.equals("xls") ? 4 : (format.equals("ooxml") ? 5 : 1)));
        return formatId;
    }

    public static int getFormatIdForImageFormat(String format) {
        int formatId = "jpeg".equals(format) ? 102 : 101;
        return formatId;
    }

    public static String getMimeTypeForFormat(String format) {
        return DataExport.getMimeTypeForFormat(DataExport.getFormatIdForFormat(format));
    }

    public static String getMimeTypeForImageFormat(String format) {
        return DataExport.getMimeTypeForImageFormat(DataExport.getFormatIdForImageFormat(format));
    }

    public static int getLineBreakStyleIdForLineBreakStyle(String lineBreakStyle) {
        int lineBreakStyleId = lineBreakStyle.equals("unix") ? 2 : (lineBreakStyle.equals("mac") ? 1 : (lineBreakStyle.equals("dos") ? 3 : 4));
        return lineBreakStyleId;
    }

    public static String getLineBreakForLineBreakStyle(String lineBreakStyle) {
        String lineBreak = lineBreakStyle.equals("unix") ? "\n" : (lineBreakStyle.equals("mac") ? "\r" : (lineBreakStyle.equals("dos") ? "\r\n" : System.getProperty("line.separator")));
        return lineBreak;
    }

    public static String getMimeTypeForFormat(int formatId) {
        String mimeType;
        switch (formatId) {
            case 2: {
                mimeType = "application/json";
                break;
            }
            case 3: {
                mimeType = "text/xml";
                break;
            }
            case 4: {
                mimeType = "application/msexcel;charset=iso-8859-1";
                break;
            }
            case 5: {
                mimeType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                break;
            }
            default: {
                mimeType = "text/csv";
            }
        }
        return mimeType;
    }

    public static String getMimeTypeForImageFormat(int formatId) {
        String mimeType;
        switch (formatId) {
            case 102: {
                mimeType = "image/jpeg";
                break;
            }
            default: {
                mimeType = "image/png";
            }
        }
        return mimeType;
    }

    public static boolean isExcel(int exportType) {
        return exportType == 4 || exportType == 5;
    }

    public DataExport() {
        this(1);
    }

    public DataExport(int output) {
        this(output, 4);
    }

    public DataExport(int output, int lineBreak) {
        this(output, lineBreak, null);
    }

    public DataExport(int output, int lineBreak, List columnOrder) {
        this(output, lineBreak, columnOrder, null);
    }

    public DataExport(int output, int lineBreak, List columnOrder, DataSource ds) {
        this(output, lineBreak, columnOrder, ds, null);
    }

    public DataExport(int output, int lineBreak, List columnOrder, DataSource ds, String delimiter) {
        this.outputType = output;
        this.lineBreakStyle = lineBreak;
        this.order = columnOrder;
        this.dataSource = ds;
        this.exportDelimiter = delimiter;
    }

    public void setOutputType(int output) {
        this.outputType = output;
    }

    public void setOrder(List order) {
        this.order = order;
    }

    public void setOrder(String[] order) {
        this.order = DataTools.arrayToList(order);
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public void exportResultSet(List rows, Writer out) throws Exception {
        this.exportResultSet(rows, (Map)null, out);
    }

    public void exportResultSet(List rows, List columns, Writer out) throws Exception {
        this.exportResultSet(rows, DataTools.identityMap(columns), out);
    }

    public int exportResultSet(List rows, Map columnRemap, Writer out) throws Exception {
        if (columnRemap == null) {
            columnRemap = this.getColumnNames(rows.listIterator());
        }
        return this.exportResultSet(rows.iterator(), columnRemap, out, null);
    }

    public int exportResultSet(Iterator iterator, Map columnRemap, Writer out1, Writer out2) throws Exception {
        return this.exportResultSet(iterator, columnRemap, out1, out2, null, null, null);
    }

    public int exportResultSet(Iterator iterator, Map columnRemap, OutputStream os, DSResponse dsResponse) throws Exception {
        return this.exportResultSet(iterator, columnRemap, null, null, os, null, dsResponse);
    }

    public int exportResultSet(Iterator iterator, Map columnRemap, OutputStream os1, OutputStream os2, DSResponse dsResponse) throws Exception {
        return this.exportResultSet(iterator, columnRemap, null, null, os1, os2, dsResponse);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int exportResultSet(Iterator iterator, Map columnRemap, Writer out1, Writer out2, OutputStream os1, OutputStream os2, DSResponse dsResponse) throws Exception {
        boolean useFieldNames;
        if (out1 == null) {
            out1 = os1 != null ? new OutputStreamWriter(os1) : new CharArrayWriter();
        }
        if (out2 == null) {
            out2 = os2 != null ? new OutputStreamWriter(os2) : new CharArrayWriter();
        }
        int contentLength = 0;
        if (!DataExport.isExcel(this.outputType) && this.header != null && !this.header.equals("")) {
            contentLength += this.write(out1, out2, this.header);
        }
        if (iterator == null) {
            log.debug("Null iterator passed to export process");
            return 0;
        }
        ArrayList<Map> rows = null;
        boolean useTitles = DataTools.getBoolean(this.settings, "useTitlesAsAttributeNames", false);
        if (config.getBoolean((Object)"export.useLegacyAttributeNaming", false)) {
            useTitles = !useTitles;
        }
        boolean bl = useFieldNames = !DataExport.isExcel(this.outputType) && !useTitles;
        if (this.settings.containsKey("exportPropertyIdentifier") && this.settings.get("exportPropertyIdentifier") != null) {
            useFieldNames = "name".equals(this.settings.get("exportPropertyIdentifier"));
        }
        if (this.outputType == 2) {
            boolean saveStrictMode = jsTrans.getStrictJSONMode();
            jsTrans.strictJSONMode();
            boolean bl2 = jsTrans.shouldWriteXMLSchemaDate();
            jsTrans.setWriteXMLSchemaDate(true);
            boolean saveUseUTC = jsTrans.shouldUseUTCInXMLSchemaDates();
            jsTrans.setUseUTCInXMLSchemaDates(false);
            jsTrans.setObfuscation(false);
            contentLength += this.writeln(out1, out2, "[");
            while (iterator.hasNext()) {
                Map row = this.getRecord(iterator.next());
                row = this.formatValues(row);
                if (!useFieldNames) {
                    row = DataTools.remapRow(row, columnRemap, false);
                }
                if (row.size() == 0) continue;
                StringWriter work = new StringWriter();
                jsTrans.toJS(row, work);
                contentLength += this.write(out1, out2, work.toString());
                if (!iterator.hasNext()) continue;
                contentLength += this.writeln(out1, out2, ",");
            }
            contentLength += this.writeln(out1, out2);
            contentLength += this.write(out1, out2, "]");
            jsTrans.setStrictJSONMode(saveStrictMode);
            jsTrans.setWriteXMLSchemaDate(bl2);
            jsTrans.setUseUTCInXMLSchemaDates(saveUseUTC);
        } else if (this.outputType == 3) {
            contentLength += this.writeln(out1, out2, "<List>");
            while (iterator.hasNext()) {
                Map row = this.getRecord(iterator.next());
                this.transformValues(row);
                row = this.formatValues(row);
                if (!useFieldNames) {
                    row = DataTools.remapRow(row, columnRemap, false);
                }
                if (row.size() == 0) continue;
                StringWriter stringWriter = new StringWriter();
                com.isomorphic.xml.XML.recordToXML("Object", row, stringWriter, false, null);
                contentLength += this.write(out1, out2, stringWriter.toString());
            }
            contentLength += this.write(out1, out2, "</List>");
        } else if (this.outputType == 1) {
            void var13_21;
            ArrayList<Object> headers;
            if (this.order != null) {
                List<String> list = this.order;
                if (columnRemap == null) {
                    headers = new ArrayList<String>(list);
                } else {
                    headers = new ArrayList();
                    for (String col : this.order) {
                        Object remapped = null;
                        if (!useFieldNames) {
                            remapped = columnRemap.get(col);
                        }
                        if (remapped != null) {
                            headers.add(remapped);
                            continue;
                        }
                        headers.add(col);
                    }
                }
            } else {
                if (columnRemap == null) {
                    rows = new ArrayList<Map>();
                    while (iterator.hasNext()) {
                        rows.add(this.getRecord(iterator.next()));
                    }
                    columnRemap = this.getColumnNames(rows.listIterator());
                }
                Set set = columnRemap.keySet();
                headers = new ArrayList(columnRemap.values());
            }
            String[] columnArray = DataTools.listToStringArray((Collection)var13_21);
            if (columnArray.length == 0) {
                log.error("Export cannot be performed with no DataSource fields..");
            } else {
                if (!this.headerless) {
                    Map otherFields;
                    List spans = null;
                    boolean exportSpans = true;
                    if (this.settings != null) {
                        spans = (List)this.settings.get("exportHeaderSpans");
                        if (this.settings.containsKey("exportShowHeaderSpanTitles")) {
                            exportSpans = DataTools.asBoolean(this.settings.get("exportShowHeaderSpanTitles"));
                        }
                    }
                    if (spans != null && exportSpans) {
                        this.addSpanTitlesToHeaders(headers, spans, null);
                    }
                    if (this.settings != null && !useFieldNames && (otherFields = (Map)this.settings.get("exportOtherFields")) != null) {
                        for (int i = 0; i < columnArray.length; ++i) {
                            String fieldName = columnArray[i];
                            String fieldTitle = (String)otherFields.get(fieldName);
                            if (fieldTitle == null) continue;
                            headers.set(i, new Header(fieldName, fieldTitle));
                        }
                    }
                    contentLength += this.writeln(out1, out2, this.getDelimitedHeaders(headers, this.exportDelimiter, "\""));
                }
                int count = 0;
                int batchSize = config.getInt("sql.streaming.batchSize", 1000);
                long start = System.currentTimeMillis();
                while (iterator.hasNext()) {
                    Map row = this.getRecord(iterator.next());
                    this.transformValues(row);
                    row = this.formatValues(row);
                    if (row.size() == 0) continue;
                    contentLength += this.write(out1, out2, this.getDelimitedValuesForRow(row, columnArray, this.exportDelimiter, "\"", true));
                    if (iterator.hasNext()) {
                        contentLength += this.writeln(out1, out2);
                    }
                    if (++count % batchSize != 0) continue;
                    out1.flush();
                    if (out2 != null) {
                        out2.flush();
                    }
                    count = 0;
                }
                log.debug("Export took " + (System.currentTimeMillis() - start) + "ms");
            }
        } else {
            if (!DataExport.isExcel(this.outputType)) throw new Exception("Invalid output type: " + String.valueOf(this.outputType));
            try {
                void var13_24;
                ExcelDataExport ede = new ExcelDataExport();
                Object var13_22 = null;
                if (dsResponse != null) {
                    Object object = dsResponse.getExportObject(null);
                }
                if (var13_24 == null) {
                    Object object = ede.getExportObject(this, this.outputType == 5, iterator, columnRemap, this.settings, this.dataSource);
                    if (dsResponse != null) {
                        dsResponse.setExportObject(object);
                    }
                } else {
                    ede.setExportObject(var13_24);
                }
                if (os1 != null || os2 != null) {
                    void var13_26;
                    ede.writeExportObject(var13_26, out1, out2, os1, os2);
                }
            }
            catch (NoClassDefFoundError e) {
                throw new Exception("Trouble loading Apache POI classes - is the  POI .jar file deployed?", e);
            }
        }
        if (this.outputType != 4 && this.outputType != 5) {
            if (this.footer != null && !this.footer.equals("")) {
                if (this.outputType == 2 || this.outputType == 3) {
                    contentLength += this.writeln(out1, out2);
                }
                contentLength += this.write(out1, out2, this.footer);
            }
            out1.flush();
            if (out2 == null) return contentLength;
            out2.flush();
            return contentLength;
        } else {
            if (os1 != null) {
                os1.flush();
            }
            if (os2 == null) return contentLength;
            os2.flush();
        }
        return contentLength;
    }

    private void addSpanTitlesToHeaders(List headers, List spans, String prefixParam) {
        if (spans == null) {
            return;
        }
        Iterator i = spans.iterator();
        while (i.hasNext()) {
            String prefix = prefixParam == null ? "" : prefixParam;
            Map span = (Map)i.next();
            prefix = prefix + span.get("title");
            if (this.settings.containsKey("exportSpanTitleSeparator")) {
                String separator = (String)this.settings.get("exportSpanTitleSeparator");
                if (separator != null) {
                    prefix = prefix + separator;
                }
            } else {
                prefix = prefix + " - ";
            }
            List subSpans = (List)span.get("spans");
            if (subSpans != null) {
                this.addSpanTitlesToHeaders(headers, subSpans, prefix);
                continue;
            }
            for (Map field : (List)span.get("fields")) {
                String fieldName = (String)field.get("name");
                String header = (String)field.get("title");
                int index = headers.indexOf(fieldName);
                if (index == -1) {
                    log.warn("Found unknown field '" + fieldName + "' while adding headerSpan " + "titles to field headers.  Ignoring.");
                    continue;
                }
                header = prefix + header;
                headers.set(index, new Header(fieldName, header));
            }
        }
    }

    private int write(Writer out1, Writer out2, String string) throws IOException {
        if (out1 != null) {
            out1.write(string);
        }
        if (out2 != null) {
            out2.write(string);
        }
        return string.length();
    }

    private int writeln(Writer out1, Writer out2, String string) throws IOException {
        int length = this.writeln(out1, string);
        this.writeln(out2, string);
        return length;
    }

    private int writeln(Writer out1, Writer out2) throws IOException {
        int length = this.writeln(out1);
        this.writeln(out2);
        return length;
    }

    private int writeln(Writer out, String string) throws IOException {
        if (out != null) {
            out.write(string);
            out.write(this.lineBreak);
        }
        return string.length() + this.lineBreak.length();
    }

    private int writeln(Writer out) throws IOException {
        if (out != null) {
            out.write(this.lineBreak);
        }
        return this.lineBreak.length();
    }

    protected String getDelimitedHeaders(String[] headers, String delimiter, String quoteChar) {
        return this.getDelimitedHeaders(Arrays.asList(headers), delimiter, quoteChar);
    }

    protected String getDelimitedHeaders(Collection headers, String delimiter, String quoteChar) {
        StringBuffer out = new StringBuffer();
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            Object header = i.next();
            if (header == null) {
                header = "";
            } else if (header instanceof Header) {
                header = ((Header)header).header;
            }
            if (quoteChar != null) {
                header = quoteChar + header + quoteChar;
            }
            out.append(header);
            if (!i.hasNext()) break;
            out.append(delimiter);
        }
        return out.toString();
    }

    protected Map getColumnNames(ListIterator rowsIterator) {
        HashMap columns = new HashMap();
        while (rowsIterator.hasNext()) {
            Map row = this.getRecord(rowsIterator.next());
            for (Object column : row.keySet()) {
                columns.put(column, column);
            }
        }
        return columns;
    }

    protected Map getColumnNames(Map record) {
        HashMap columns = new HashMap();
        for (Object column : record.keySet()) {
            columns.put(column, column);
        }
        return columns;
    }

    public String getDelimitedValues(Collection rows, Collection columns, String delimiter, String quoteChar) {
        return this.getDelimitedValues(rows, DataTools.listToStringArray(columns), delimiter, quoteChar);
    }

    public String getDelimitedValues(Collection rows, String[] columns, String delimiter, String quoteChar) {
        StringWriter output = new StringWriter();
        PrintWriter out = new PrintWriter(output);
        Iterator e = rows.iterator();
        while (e.hasNext()) {
            Map row;
            Object o = e.next();
            if (o instanceof Map) {
                row = (Map)o;
            } else if (this.dataSource != null) {
                row = this.dataSource.getProperties(o);
            } else {
                log.warn("Either provide a collection of Maps or a DataSource; can't export " + o.getClass().getName());
                continue;
            }
            out.print(this.getDelimitedValuesForRow(row, columns, delimiter, quoteChar, false));
            if (!e.hasNext()) continue;
            this.printLine(out, "");
        }
        out.flush();
        return output.toString();
    }

    public String getDelimitedValuesForRow(Map row, Collection columns, String delimiter, String quoteChar, boolean escapeNewLine) {
        return this.getDelimitedValuesForRow(row, DataTools.listToStringArray(columns), delimiter, quoteChar, escapeNewLine);
    }

    public String getDelimitedValuesForRow(Map row, String[] columns, String delimiter, String quoteChar, boolean escapeNewLine) {
        StringBuffer serialized = new StringBuffer();
        int i = 0;
        while (true) {
            String stringValue;
            Object value = columns[i] != null ? (Object)row.get(columns[i]) : null;
            DSField field = null;
            if (this.dataSource != null) {
                field = this.dataSource.getField(columns[i]);
            }
            try {
                if (value == null) {
                    stringValue = "";
                } else if (value instanceof Date) {
                    boolean omitTime = false;
                    if (field != null) {
                        omitTime = "date".equals(field.getType());
                    }
                    String format = "yyyy-MM-dd";
                    if (!omitTime) {
                        format = format + " HH:mm:ss";
                    }
                    stringValue = DataTools.formatDate(format, (Date)value);
                } else {
                    stringValue = value.toString();
                }
            }
            catch (Exception err) {
                stringValue = "";
            }
            if (quoteChar != null) {
                Perl5Util perl = new Perl5Util();
                String pattern = quoteChar.equals("/") ? "s#" + quoteChar + "#" + quoteChar + quoteChar + "#g" : "s/" + quoteChar + "/" + quoteChar + quoteChar + "/g";
                stringValue = perl.substitute(pattern, stringValue);
                stringValue = quoteChar + stringValue + quoteChar;
            }
            if (escapeNewLine) {
                stringValue = stringValue.replace('\n', ' ');
            }
            serialized.append(stringValue);
            if (++i >= columns.length) break;
            serialized.append(delimiter);
        }
        return serialized.toString();
    }

    public void printLine(PrintWriter out, String printText) {
        if (!printText.equals("")) {
            out.print(printText);
        }
        out.print(this.lineBreak);
    }

    public Map getRecord(Object data) {
        if (data instanceof Map) {
            return (Map)data;
        }
        if (data == null) {
            return null;
        }
        if (this.dataSource == null) {
            log.warn("Trying to export an object of type " + data.getClass().getCanonicalName() + ", but dataSource is null.  Returning an empty Map.");
            return new HashMap();
        }
        IBeanFilter filter = null;
        if (data instanceof JSONFilter) {
            filter = ((JSONFilter)data).getBeanFilter();
            data = ((JSONFilter)data).getObj();
        }
        Map record = this.dataSource.getProperties(data);
        if (filter != null) {
            try {
                record = filter.filter(record);
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to filter record:'" + filter), ex);
            }
        }
        return record;
    }

    protected Map formatValues(Map record) {
        HashMap newRecord = new HashMap();
        for (String fieldName : record.keySet()) {
            String javaFormat;
            if (fieldName.endsWith("$style")) continue;
            Map style = (Map)record.get(fieldName + "$style");
            if (style != null) {
                if (this.exportRawValues) {
                    if (style.get("rawValue") != null) {
                        newRecord.put(fieldName, style.get("rawValue"));
                        continue;
                    }
                    newRecord.put(fieldName, record.get(fieldName));
                    continue;
                }
                newRecord.put(fieldName, record.get(fieldName));
                continue;
            }
            if (this.dataSource == null || this.exportRawValues) {
                newRecord.put(fieldName, record.get(fieldName));
                continue;
            }
            DSField field = this.dataSource.getField(fieldName);
            if (field == null) {
                newRecord.put(fieldName, record.get(fieldName));
                continue;
            }
            String format = (String)field.get("exportFormat");
            if (format == null) {
                format = (String)field.get("format");
            }
            if (format == null) {
                newRecord.put(fieldName, record.get(fieldName));
                continue;
            }
            Object value = record.get(field.getName());
            if (value instanceof Date) {
                SimpleDateFormat sdf = this.dateFormatCache.get(format);
                if (sdf == null) {
                    javaFormat = format.replace("dddd", "EEEE");
                    javaFormat = javaFormat.replace("ddd", "EEE");
                    sdf = new SimpleDateFormat(javaFormat);
                    this.dateFormatCache.put(format, sdf);
                }
                newRecord.put(fieldName, sdf.format((Date)value));
                continue;
            }
            if (value instanceof Number) {
                DecimalFormat df = this.numberFormatCache.get(format);
                if (df == null) {
                    javaFormat = format.replace("\u00a4", this.currencySymbol);
                    df = new DecimalFormat(javaFormat);
                    this.numberFormatCache.put(format, df);
                }
                newRecord.put(fieldName, df.format((Number)value));
                continue;
            }
            newRecord.put(fieldName, record.get(fieldName));
        }
        return newRecord;
    }

    protected void transformValues(Map record) throws Exception {
        for (String fieldName : record.keySet()) {
            if (fieldName.endsWith("$style")) continue;
            Object fieldValue = record.get(fieldName);
            if (fieldValue instanceof Reader) {
                StringWriter sw = new StringWriter();
                IOUtil.copyCharacterStreams((Reader)fieldValue, sw);
                record.put(fieldName, sw.toString());
                continue;
            }
            if (!(fieldValue instanceof InputStream)) continue;
            record.put(fieldName, IOUtil.inputStreamToString((InputStream)fieldValue));
        }
    }

    private static final class Header {
        public final String fieldName;
        public final String header;

        public Header(String fieldName, String header) {
            this.fieldName = fieldName;
            this.header = header;
        }
    }
}

