/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLOrderClause
extends Base {
    private static Logger log = new Logger(SQLOrderClause.class.getName());
    private List dataSources;
    private Map remapTable;
    private Map column2TableMap = new HashMap();
    private Map valueMaps;
    private List sortBy;
    private boolean qualifyColumnNames;
    private List customValueFields = null;
    private DSRequest request;
    private String overridingTableName;
    private boolean isSqlLimitClause = false;

    public SQLOrderClause(DSRequest request, List dataSources, boolean qualifyColumnNames, boolean isSqlLimitClause) {
        this(request, dataSources, qualifyColumnNames);
        this.isSqlLimitClause = isSqlLimitClause;
    }

    public SQLOrderClause(DSRequest request, List dataSources, boolean qualifyColumnNames, String overridingTableName) {
        this(request, dataSources, qualifyColumnNames);
        this.overridingTableName = overridingTableName;
    }

    public SQLOrderClause(DSRequest request, List dataSources, boolean qualifyColumnNames) {
        this.request = request;
        this.dataSources = dataSources;
        this.qualifyColumnNames = qualifyColumnNames;
        this.sortBy = new ArrayList();
        List inboundSortBy = request.getSortByFields();
        for (String field : inboundSortBy) {
            if (field.startsWith("-")) {
                field = field.substring(1);
            }
            this.sortBy.add(field);
        }
        this.remapTable = SQLDataSource.getField2ColumnMap(dataSources);
        if (dataSources.size() > 1) {
            this.column2TableMap = SQLDataSource.getColumn2TableMap(dataSources);
        }
        this.valueMaps = SQLDataSource.getCombinedValueMaps(dataSources, this.sortBy);
        this.sortBy = inboundSortBy;
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public boolean isJoin() {
        return this.dataSources.size() > 1;
    }

    public boolean isEmpty() {
        return this.sortBy == null;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }

    public String getSQLString() throws Exception {
        if (this.isEmpty()) {
            log.debug((Object)"no data; returning empty string");
            return "";
        }
        String[] orderByElements = new String[this.sortBy.size()];
        SQLDriver driver = ((SQLDataSource)((Object)this.dataSources.get(0))).getDriver();
        int index = -1;
        Iterator i = this.sortBy.iterator();
        while (i.hasNext()) {
            SummaryFunctionType function;
            DataSource firstDS;
            ++index;
            String fieldName = (String)i.next();
            boolean descending = false;
            if (fieldName.startsWith("-")) {
                fieldName = fieldName.substring(1);
                descending = true;
            }
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator j = this.customValueFields.iterator();
                while (j.hasNext()) {
                    if (!j.next().equals(fieldName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            String overrideTableName = null;
            DSField field = null;
            boolean exclude = false;
            for (int j = 0; j < this.dataSources.size(); ++j) {
                DataSource ds = (DataSource)this.dataSources.get(j);
                field = ds.getField(fieldName);
                if (field != null) {
                    if (field.getIncludeFromDefinition(this.request) != null) {
                        exclude = true;
                        break;
                    }
                    if (field.isInapplicable()) {
                        exclude = true;
                        break;
                    }
                    if (!skipCustomSQLCheck && field.getBoolean("customSQL")) {
                        exclude = true;
                        break;
                    }
                    if (this.overridingTableName != null) {
                        overrideTableName = this.overridingTableName;
                        break;
                    }
                    if (field.get((Object)"tableName") == null) break;
                    overrideTableName = field.get((Object)"tableName").toString();
                    break;
                }
                exclude = true;
            }
            if (exclude) continue;
            Map valueMap = (Map)this.valueMaps.get(fieldName);
            String columnName = (String)this.remapTable.get(fieldName);
            if (columnName == null) {
                log.warn((Object)("DataSource '" + ((DataSource)this.dataSources.get(0)).getName() + "': Attempting to sort by field '" + fieldName + "', but found no " + "native column for the field. Ignoring."));
                continue;
            }
            boolean limitQueryUseColumnName = fieldName.equals(columnName);
            String tableName = overrideTableName;
            if (tableName == null) {
                tableName = (String)this.column2TableMap.get(fieldName);
            }
            columnName = driver.escapeColumnName(columnName);
            if (tableName == null && this.qualifyColumnNames && (firstDS = (DataSource)this.dataSources.get(0)) instanceof SQLDataSource) {
                tableName = ((SQLDataSource)firstDS).getTable().getNameQuotedIfNecessary((SQLDataSource)firstDS);
            }
            String unqualifiedColumnName = columnName;
            if (!this.isSqlLimitClause) {
                if (!this.qualifyColumnNames && overrideTableName != null) {
                    columnName = overrideTableName + "." + columnName;
                } else if (tableName != null) {
                    columnName = (overrideTableName == null ? tableName : overrideTableName) + "." + columnName;
                }
            }
            String functionName = null;
            if (this.request.getSummaryFunctions() != null && (function = (SummaryFunctionType)this.request.getSummaryFunctions().get(fieldName)) != null) {
                functionName = function.getFunctionName();
            }
            if (functionName == null) {
                functionName = field.getProperty("includeSummaryFunction");
            }
            if (functionName != null) {
                if ("FIRST".equals(functionName.toUpperCase())) {
                    functionName = "MIN";
                }
                functionName = functionName.toLowerCase();
            }
            String text = "";
            text = field != null && (field.getProperty("customSelectExpression") != null || field.getProperty("customSQLExpression") != null) ? text + unqualifiedColumnName : (this.isSqlLimitClause ? text + driver.getExpressionForSortBy(limitQueryUseColumnName ? unqualifiedColumnName : fieldName, valueMap, functionName, this.request) : text + driver.getExpressionForSortBy(columnName, valueMap, functionName, this.request));
            orderByElements[index] = text = text + (descending ? " DESC" : "");
        }
        this.addSQLForJoinedFields(driver, orderByElements);
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < orderByElements.length; ++i2) {
            String element = orderByElements[i2];
            if (element == null) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(element);
        }
        return buf.toString();
    }

    private void addSQLForJoinedFields(SQLDriver driver, String[] elements) throws Exception {
        if (this.request.getIncludeFrom() == null || this.request.getIncludeFrom().size() == 0) {
            return;
        }
        for (IncludeFromDefinition incFrom : this.request.getIncludeFrom()) {
            if (incFrom.isInError() || (incFrom.isDynamic() ? !incFrom.isSortBy() : !this.sortBy.contains(incFrom.getThisFieldName()) && !this.sortBy.contains("-" + incFrom.getThisFieldName()))) continue;
            IncludeFromDefinition originalIncFrom = incFrom;
            String thisFieldName = incFrom.getThisFieldName();
            IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
            while (target != null && incFrom.getDataSource() instanceof SQLDataSource) {
                incFrom = target;
                target = incFrom.getTargetIncludeFrom();
            }
            if (!(incFrom.getDataSource() instanceof SQLDataSource)) continue;
            String includedFieldName = incFrom.getIncludedFieldName();
            String columnName = incFrom.getIncludedField().getNativeName();
            if (columnName == null) {
                columnName = includedFieldName;
            }
            String tableName = ((SQLDataSource)incFrom.getDataSource()).getTable().getNameQuotedIfNecessary((SQLDataSource)incFrom.getDataSource());
            String alias = incFrom.getAlias();
            if (alias != null) {
                tableName = alias;
            }
            int j = -1;
            boolean descending = false;
            for (int k = 0; k < this.sortBy.size(); ++k) {
                descending = false;
                String name = (String)this.sortBy.get(k);
                IncludeFromDefinition temp = null;
                if (name.substring(0, 1).equals("-")) {
                    name = name.substring(1);
                    descending = true;
                }
                if ((temp = IncludeFromDefinition.forSortByField((List)this.request.getIncludeFrom(), (String)name, (boolean)IncludeFromDefinition.isDynamicInclusion((String)name))) != originalIncFrom) continue;
                j = k;
                break;
            }
            if (j == -1) {
                log.warn((Object)("Building order by clause, could not locate the correct index for includeFrom field " + incFrom.getThisFieldName() + " (" + incFrom.getDataSourceName() + "." + incFrom.getIncludedFieldName() + ")"));
                continue;
            }
            List outputs = this.request.getConsolidatedOutputs();
            String text = "";
            text = incFrom.isDynamic() || outputs != null && !outputs.contains(thisFieldName) ? driver.sqlOutTransform(columnName, null, tableName) : thisFieldName;
            if (descending) {
                text = text + " DESC";
            }
            elements[j] = text;
        }
    }

    public void setSortBy(List sortBy) {
        this.sortBy = sortBy;
    }
}

