/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.util.privilegedactions.ConstructorInstance;
import org.hibernate.validator.util.privilegedactions.GetAnnotationParameter;
import org.hibernate.validator.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.util.privilegedactions.GetConstructor;
import org.hibernate.validator.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.util.privilegedactions.GetDeclaredFields;
import org.hibernate.validator.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.util.privilegedactions.GetMethod;
import org.hibernate.validator.util.privilegedactions.GetMethodFromPropertyName;
import org.hibernate.validator.util.privilegedactions.LoadClass;
import org.hibernate.validator.util.privilegedactions.NewInstance;
import org.hibernate.validator.util.privilegedactions.SetAccessibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static ClassLoader getClassLoaderFromContext() {
        GetClassLoader action = GetClassLoader.fromContext();
        ClassLoader loader = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return loader;
    }

    public static ClassLoader getClassLoaderFromClass(Class<?> clazz) {
        GetClassLoader action = GetClassLoader.fromClass(clazz);
        ClassLoader loader = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return loader;
    }

    public static Class<?> loadClass(String className, Class<?> caller) {
        LoadClass action = LoadClass.action(className, caller);
        if (System.getSecurityManager() != null) {
            return (Class)AccessController.doPrivileged(action);
        }
        return action.run();
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... params) {
        GetConstructor<T> action = GetConstructor.action(clazz, params);
        Object constructor = System.getSecurityManager() != null ? (Constructor)AccessController.doPrivileged(action) : action.run();
        return constructor;
    }

    public static <T> T newInstance(Class<T> clazz, String message) {
        NewInstance<T> newInstance = NewInstance.action(clazz, message);
        T instance = System.getSecurityManager() != null ? AccessController.doPrivileged(newInstance) : newInstance.run();
        return instance;
    }

    public static <T> T newConstructorInstance(Constructor<T> constructor, Object ... initArgs) {
        ConstructorInstance<T> newInstance = ConstructorInstance.action(constructor, initArgs);
        T instance = System.getSecurityManager() != null ? AccessController.doPrivileged(newInstance) : newInstance.run();
        return instance;
    }

    public static <T> T getAnnotationParameter(Annotation annotation, String parameterName, Class<T> type) {
        GetAnnotationParameter<T> action = GetAnnotationParameter.action(annotation, parameterName, type);
        T result = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return result;
    }

    public static String getPropertyName(Member member) {
        String name = null;
        if (member instanceof Field) {
            name = member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            if (methodName.startsWith("is")) {
                name = Introspector.decapitalize(methodName.substring(2));
            } else if (methodName.startsWith("has")) {
                name = Introspector.decapitalize(methodName.substring(3));
            } else if (methodName.startsWith("get")) {
                name = Introspector.decapitalize(methodName.substring(3));
            }
        }
        return name;
    }

    public static boolean propertyExists(Class<?> clazz, String property, ElementType elementType) {
        return ReflectionHelper.getMember(clazz, property, elementType) != null;
    }

    public static Member getMember(Class<?> clazz, String property, ElementType elementType) {
        if (clazz == null) {
            throw new IllegalArgumentException("The class cannot be null");
        }
        if (property == null || property.length() == 0) {
            throw new IllegalArgumentException("Property name cannot be null or empty");
        }
        if (!ElementType.FIELD.equals((Object)elementType) && !ElementType.METHOD.equals((Object)elementType)) {
            throw new IllegalArgumentException("Element type has to be FIELD or METHOD");
        }
        Member member = null;
        if (ElementType.FIELD.equals((Object)elementType)) {
            GetDeclaredField action = GetDeclaredField.action(clazz, property);
            member = System.getSecurityManager() != null ? (Member)AccessController.doPrivileged(action) : action.run();
        } else {
            String[] prefixes;
            String methodName = property.substring(0, 1).toUpperCase() + property.substring(1);
            for (String prefix : prefixes = new String[]{"is", "get", "has"}) {
                GetMethod action = GetMethod.action(clazz, prefix + methodName);
                member = System.getSecurityManager() != null ? (Member)AccessController.doPrivileged(action) : action.run();
                if (member != null) break;
            }
        }
        return member;
    }

    public static Class<?> getType(Member member) {
        Class<?> type = null;
        if (member instanceof Field) {
            type = ((Field)member).getType();
        }
        if (member instanceof Method) {
            type = ((Method)member).getReturnType();
        }
        return type;
    }

    public static Type typeOf(Member member) {
        Type type;
        if (member instanceof Field) {
            type = ((Field)member).getGenericType();
        } else if (member instanceof Method) {
            type = ((Method)member).getGenericReturnType();
        } else {
            throw new IllegalArgumentException("Member " + member + " is neither a field nor a method");
        }
        if (type instanceof TypeVariable) {
            type = TypeUtils.getErasedType(type);
        }
        return type;
    }

    public static Object getValue(Member member, Object object) {
        Object value = null;
        if (member instanceof Method) {
            Method method = (Method)member;
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + method.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to access " + method.getName(), (Throwable)e);
            }
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + field.getName(), (Throwable)e);
            }
        }
        return value;
    }

    public static void setAccessibility(Member member) {
        SetAccessibility action = SetAccessibility.action(member);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
    }

    public static Type getIndexedType(Type type) {
        Type indexedType = null;
        if (ReflectionHelper.isIterable(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[0];
        } else if (ReflectionHelper.isMap(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[1];
        } else if (TypeUtils.isArray(type)) {
            indexedType = TypeUtils.getComponentType(type);
        }
        return indexedType;
    }

    public static boolean isIterable(Type type) {
        if (type instanceof Class && ReflectionHelper.extendsOrImplements((Class)type, Iterable.class)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isIterable(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isIterable(upperBounds[0]);
        }
        return false;
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && ReflectionHelper.extendsOrImplements((Class)type, Map.class)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isMap(upperBounds[0]);
        }
        return false;
    }

    public static boolean isList(Type type) {
        if (type instanceof Class && ReflectionHelper.extendsOrImplements((Class)type, List.class)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isList(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isList(upperBounds[0]);
        }
        return false;
    }

    public static Object getIndexedValue(Object value, Integer index) {
        Iterator<Object> iter;
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
        } else if (TypeUtils.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
        } else {
            return null;
        }
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (i == index) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static Object getMappedValue(Object value, Object key) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        return map.get(key);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        GetDeclaredField action = GetDeclaredField.action(clazz, fieldName);
        Field field = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return field;
    }

    public static boolean containsField(Class<?> clazz, String fieldName) {
        return ReflectionHelper.getField(clazz, fieldName) != null;
    }

    public static Field[] getFields(Class<?> clazz) {
        GetDeclaredFields action = GetDeclaredFields.action(clazz);
        Field[] fields = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return fields;
    }

    public static Method getMethodFromPropertyName(Class<?> clazz, String methodName) {
        GetMethodFromPropertyName action = GetMethodFromPropertyName.action(clazz, methodName);
        Method method = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return method;
    }

    public static boolean containsMethodWithPropertyName(Class<?> clazz, String property) {
        return ReflectionHelper.getMethodFromPropertyName(clazz, property) != null;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        GetMethod action = GetMethod.action(clazz, methodName);
        Method method = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return method;
    }

    public static Method[] getMethods(Class<?> clazz) {
        GetDeclaredMethods action = GetDeclaredMethods.action(clazz);
        Method[] methods = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        return methods;
    }

    public static boolean containsMethod(Class<?> clazz, String methodName) {
        return ReflectionHelper.getMethodFromPropertyName(clazz, methodName) != null;
    }

    public static Class<?> boxedType(Type primitiveType) {
        if (!(primitiveType instanceof Class) && !((Class)primitiveType).isPrimitive()) {
            throw new IllegalArgumentException(primitiveType.getClass() + "has to be a primitive type");
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        throw new RuntimeException("Unhandled primitive type.");
    }

    public static List<Class<?>> computeClassHierarchy(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        ReflectionHelper.computeClassHierarchy(clazz, classes);
        return classes;
    }

    private static void computeClassHierarchy(Class<?> clazz, List<Class<?>> classes) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                ReflectionHelper.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private static boolean extendsOrImplements(Class<?> clazz, Class<?> superClassOrInterface) {
        List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(clazz);
        return classes.contains(superClassOrInterface);
    }
}

