
package com.smartgwt.client.docs;

/**
 * <h3>Transaction Chaining</h3>
 * <i>Transaction Chaining</i> allows {@link com.smartgwt.client.rpc.RPCManager#startQueue queues}
 * of {@link com.smartgwt.client.data.DSRequest}s to be "chained" together, such that later
 * <code>DSRequests</code> in the queue can use the results of previous requests in the queue. 
 * This allows you to declaratively handle various situations where information only becomes
 * available during the processing of a queue. <p> Transaction Chaining is only available with
 * Power Edition licenses or better.  See the <a href='http://smartclient.com/product/'
 * target='_blank'>Editions &amp; Pricing page</a> for details. <p> As an example of Transaction
 * Chaining, consider an application that needs to do a master-detail add, which involves saving a
 * new Record representing a sales order to an <code>order</code> DataSource, and also saving
 * several related Records representing individual items in the order to an <code>orderItem</code>
 * DataSource.  The Records for the individual <code>orderItem</code>s need to set up foreign keys
 * referencing the primary key assigned to the Record for the <code>order</code>, but the primary
 * key of the <code>order</code> record is assigned only when the Record is inserted into the
 * database; it cannot be known up-front. <p> You could resolve this programmatically - for
 * example, you could use DMIs to store and retrieve the PK value using
 * <code>servletRequest</code> attributes - but Transaction Chaining gives you an elegant,
 * declarative, code-free alternative, giving you a way to declare that the foreignKey value for
 * the <code>orderItem</code> records should use the primary key value resulting from the creation
 * of the <code>order</code> record earlier in the same queue. <p> As another example, consider an
 * application that allows a user to submit a free-form question which must be persisted to the
 * database like a normal update, but which should initially show the user a list of
 * previously-provided answers that appear to be relevant. The operation that handles the add of
 * the question categorizes it by analyzing the text, and the category is added to the record
 * inserted into the database, and thus to the record returned in the response.  Now, via
 * transaction chaining, a "fetch" operation later in the queue can pick up the newly assigned
 * category and use it in criteria to fetch the list of related answers. <p> Transaction Chaining
 * is implemented by specifying {@link com.smartgwt.client.docs.serverds.DSRequestModifier}s in 
 * {@link com.smartgwt.client.docs.serverds.OperationBinding#values OperationBinding.values} and
 * {@link com.smartgwt.client.docs.serverds.OperationBinding#criteria OperationBinding.criteria}. 
 * These two properties provide a general means of declaratively modifying DSRequests server-side,
 * and transaction chaining is only one of their uses.  They can also be used, for example, to
 * implement security rules, by adding the currently-authorized user to the criteria of all fetch
 * requests. <p> Specifically for transaction chaining, you specify <code>criteria </code> and/or 
 * <code>values</code> entries on the <code>operationBinding</code> where the  {@link
 * com.smartgwt.client.docs.serverds.DSRequestModifier#getValue value} property references the
 * special <b>$responseData</b> Velocity context variable - see the "value" link for more details.
 * Alternatively, you  can use the <code>RPCManager</code> APIs <code>getFirstResponse()</code>
 * and  <code>getLastResponse()</code> to get access to the same information, either 
 * programmatically from DMI or custom DataSource Java code, or in Velocity expressions via  the
 * <b>$rpc</b> context variable.
 * @see com.smartgwt.client.docs.serverds.DSRequestModifier
 * @see com.smartgwt.client.docs.serverds.DSRequestModifier#getValue
 * @see com.smartgwt.client.docs.serverds.DSRequestModifier#getStart
 * @see com.smartgwt.client.docs.serverds.DSRequestModifier#getEnd
 * @see com.smartgwt.client.docs.serverds.OperationBinding#criteria
 * @see com.smartgwt.client.docs.serverds.OperationBinding#values
 */
public interface TransactionChaining {
}
