package com.smartgwt.client.docs;

/**
 *  <h3>Smart GWT Pro/Power/EE Project Setup &amp; Deployment</h3>
 *  <b>Creating a new project from scratch</b>
 *  <P>
 *  If you are starting a new project from scratch, we recommend starting with one of the sample
 *  projects included with Smart GWT Pro/Power/EE under the "samples" directory.  Use the project that most
 *  closely matches your integration strategy and follow the instructions in the "README" file
 *  within the sample directory.
 *  <P>
 *  Note <b>if you rename the GWT module</b> (e.g. "builtinds" &#8594; "myApplication") you need to make
 *  changes to several files which contain the GWT module name in filesystem paths or URLs.
 *  See the set of steps for adding Smart GWT to an existing project to see all the files that
 *  may need changes.
 *  <P>
 *  <b>Adding Smart GWT Pro/Power/EE to an existing project</b>
 *  <P>
 *  <B>Important:</b> If you have created a project using the GWT Plugin for Eclipse or a
 *  similar tool, first get rid of unused resources typically included in such "starter projects":
 *  <ul>
 *    <li> from your <i>moduleName</i>.gwt.xml file, remove imports of any GWT themes, leaving
 *         only the import of <code>com.google.gwt.user.User</code>.  The proper imports to add for Smart GWT
 *         Pro/Power/EE are shown below.
 *    <li> get rid of any sample servlets or GWT-RPC services (delete both web.xml entries and
 *         server-side source)
 *  </ul>
 *  <P>
 *  Now add Smart GWT Pro/Power/EE: all of these steps are required.  <b>Do not skip steps or omit
 *  resources you think you may not need</b>.  Get a working project first, then think about
 *  trimming resources, as needed, once you understand the system.
 *  <P>
 *  In the steps below, copying from e.g. "war/WEB-INF/..." means copying from the "war"
 *  subdirectory of whichever sample project is closest to your desired integration strategy.
 *  <P>
 *  <ol>
 *  <li>Add all jars from the Smart GWT Pro/Power/EE distribution (under smartgwtee-<i>version</i>/lib)
 *      to your CLASSPATH.  You can copy the '.classpath' file from the appropriate sample
 *      project for a working set of includes (it's in the same directory as the <i>war/</i>
 *      folder). There are both client- and server-side jars, and both kinds go in the classpath.
 *      For server-side .jars, dependencies are documented
 *      {@link com.smartgwt.client.docs.JavaModuleDependencies here}.
 *  <li>Update your <i>modulename</i>.gwt.xml file with these imports:
 *     <pre>
 *     &lt;inherits name="com.smartgwtee.SmartGwtEE"/&gt;
 *     &lt;inherits name="com.smartgwtee.tools.Tools"/&gt;
 *     </pre>
 *     <ul>
 *     <li> <b>NOTE:</b> if you were previously using Smart GWT LGPL, <b>remove</b> the import of
 *          'com.smartgwt.SmartGWT'.
 *     <li> <b>NOTE:</b> if you are importing com.smartgwt.tools.SmartGwtTools (for the
 *          Developer Console), continue to do so, but place this import <b>before</b> the
 *          com.smartgwtee.* imports
 *     </ul>
 *  <li>Modify the bootstrap HTML file (<i>modulename</i>.html) to set the isomorphicDir:
 *     <pre>
 *     &lt;script&gt;
 *     var isomorphicDir = "<i>modulename</i>/sc/";
 *     &lt;/script&gt;
 *     </pre>
 *     This should appear before the &lt;script src=&gt; tag that loads *.nocache.js.
 *  <li> Copy war/WEB-INF/classes/log4j.config.xml across to the "src" dir of your project (it's
 *       placed in the "src" dir as a means of getting it into the CLASSPATH).  This enables default
 *       log4j categories for server-side logs appropriate for development.
 *  <li> Copy war/WEB-INF/classes/server.properties across to the "src" dir of your project.
 *       This contains miscellaneous server settings - see the file itself for documentation.
 *     <ul>
 *        <li><b>server.properties contains server-side paths that contain the GWT module name</b>.
 *            Replace the module name from the sample project (e.g. "builtinds") with the module
 *            name of your actual GWT project 
 *        <li> If you're using SQLDataSource, enter your JDBC settings (start with a
 *             server.properties from a project that uses a database to see the required format for
 *             settings)
 *     </ul>
 *  <li> Merge web.xml, starting with the web.xml from the sample project that is closest to
 *       your target application (under war/WEB-INF in the sample project).
 *     <ul>
 *        <li>the GWT module name from the sample project (e.g. "builtinds") appears in several
 *            paths within web.xml.  This needs to be changed to the module name you chose for
 *            your project.
 *        <li>the list of servlets and what they do is documented {@link com.smartgwt.client.docs.ServletDetails here}.  See the
 *            server-side JavaDoc for further details on servlet APIs and override points.
 *     </ul>
 *  <li> Copy war/WEB-INF/iscTaglib.xml to your war/WEB-INF/iscTaglib.xml.  This is required for
 *       JSP tags to work and used by tools such as Visual Builder.  Be sure you have also
 *       copied the web.xml section that enables the taglib (&lt;jsp-config&gt; element) 
 *  <li> (SmartGWT Power or Enterprise only) If using the BatchUpload functionality, copy
 *       war/ds/batchUpload.ds.xml from the Showcase sample project to the shared.datasources
 *       directory you configured in server.properties.
 *  </ol>
 *
 *  <b>Troubleshooting</b>
 *  <table width="90%" class="normal" align="center" border="1" cellpadding="5">
 *  <tr bgcolor="#808080">
 *  	<td width="30%"><b>Problem</b></td>
 *  	<td width="30%"><b>Possible Causes</b></td>
 *  	<td width="40%"><b>Solution</b></td>
 *  </tr><tr>
 *   <td>ClassNotFound or other Java Exceptions in the server log.</td>
 *   <td>Missing JAR files</td>
 *   <td>Verify every .jar from the smartgwtee-<i>version</i>/lib directory has been added to your CLASSPATH.
 *   Although you might later be able to remove some .jars, for initial installation testing,
 *   copy every .jar</td>
 *  </tr><tr>
 *  	<td>Client-side error about attempting to use "iscServer" request without server installed</td>
 *  	<td>Wrong imports in <i>moduleName</i>.gwt.xml</td>
 *  	<td>See correct imports above, note <b>remove</b> com.smartgwt.SmartGWT import and
 *          ensure that com.smartgwt.tools.SmartGwtTools import is <b>before</b> your
 *          com.smartgwtee.* imports (or corresponding Pro/Power imports)</td>
 *  </tr><tr>
 *  	<td>Missing images or failure to load page</td>
 *  	<td>Didn't set isomorphicDir in .html bootstrap file</td>
 *  	<td>See step above for setting isomorphicDir</td>
 *  </tr><tr>
 *  	<td>Server error: "adminConsole" app not found when launching tools such as Visual Builder</td>
 *  	<td>Bad filesystem paths configured in server.properties</td>
 *  	<td>Correct paths in server.properties.  <b>NOTE</b> the samples include the GWT module
 *       name in some settings, search and replace this value with your GWT module name</td>
 *  </tr><tr>
 *  	<td>Server error: Can't find DataSource with ID <i>yourDataSourceID</i></td>
 *  	<td>Bad filesystem paths in server.properties or bad DataSource .ds.xml file</td>
 *  	<td>Correct paths in server.properties - search for "project.datasources".  Also check that
 *       the DataSource ID you are using matches the "ID" attribute in the .ds.xml file (NOTE:
 *       ID attribute is uppercase "ID" not "id") and that the file is named
 *       <i>dataSourceId</i>.ds.xml.  DataSource IDs are <b>case sensitive</b>, including the
 *       file name</td>
 *  </tr><tr>
 *  	<td>Server error: taglib not defined</td>
 *  	<td>Missing iscTaglib.xml or iscTaglib.xml not referenced in web.xml</td>
 *  	<td>See step above about iscTaglib.xml and web.xml entry</td>
 *  </tr>
 *  </table>
 *  <P>
 *  For further troubleshooting steps, see
 *  <a href="http://forums.smartclient.com/showthread.php?t=8159" target='_blank'>the SmartGWT FAQ</a>
 *  and, if still stuck, try posting in the Forums. <B>NOTE:</B> gather all the information indicated in
 *  the FAQ before posting.
 */
public interface SgwtEESetup {
}
