
/*
 * Isomorphic Smart GWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.client.docs.serverds;

import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.docs.*;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.List;
import java.util.Map;

/**
 * Specification of an operator for use in filtering, for example "equals".<p>
 * <b>This class is not meant to be created and used, it is actually documentation of settings
 * allowed in a DataSource descriptor (.ds.xml file), for use with Smart GWT Pro Edition and
 * above.
 * See {@link com.smartgwt.client.docs.serverds} for how to use this documentation.</b>
 * <p>
 * Use with {@link com.smartgwt.client.data.DataSource#addSearchOperator
 * DataSource.addSearchOperator()} to define custom filtering behaviors for client-side filtering.
 */
public class Operator {

    /**
     * List of types that this Operator is valid for. <P> If omitted, the operator is assumed to be
     * valid for all FieldTypes unless a list of  FieldTypes is passed to {@link
     * com.smartgwt.client.data.DataSource#addSearchOperator DataSource.addSearchOperator()}.
     *
     * <p>Default value is null
     */
    public FieldType[] fieldTypes;

    /**
     * The text use when using this operator as an  {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getAllowExpressions expression} in a FormItem.
     *
     * <p>Default value is null
     */
    public String symbol;

    /**
     * Indicates the kind of value expected in a {@link com.smartgwt.client.data.Criterion} that uses
     * this operator. {@link com.smartgwt.client.types.OperatorValueType} lists possibilities. <P> The
     * default of <code>null</code> is equivalent to "fieldType", indicating that {@link
     * com.smartgwt.client.data.Criterion#getValue Criterion.value} is expected to contain a value of
     * the same type as the field indicated by {@link com.smartgwt.client.data.Criterion#getFieldName
     * Criterion.fieldName}.
     *
     * <p>Default value is null
     */
    public OperatorValueType valueType;

    /**
     * Name of a property on the Operators class that provides the title for this operator.
     *
     * <p>Default value is null
     */
    public String titleProperty;

    /**
     * For an operator with  valueType:"custom", indicates what kind of FormItem to use to provide a
     * user interface for creating a valid {@link com.smartgwt.client.data.Criterion}.  The default of
     * <code>null</code> means an ordinary TextItem is fine.
     *
     * <p>Default value is null
     */
    public FormItem editorType;

    /**
     * Unique id for an operator, which appears within {@link
     * com.smartgwt.client.data.AdvancedCriteria} as the Operator property. <P> A list of built-in
     * identifiers is {@link com.smartgwt.client.types.OperatorId here}.
     *
     * <p>Default value is null
     */
    public OperatorId ID;

    /**
     * User-visible title for this operator, such as "doesn't contain". <P> To simplify
     * internationalization by separating titles from operator code, you can use specify 
     * titleProperty instead of this property.
     *
     * <p>Default value is null
     */
    public String title;

    /**
     * Whether this operator should be offered to users by default in interfaces such as the {@link
     * com.smartgwt.client.widgets.form.FilterBuilder}.   <P> Setting hidden:true means the operator
     * can be used in a programmatic search, for example, by calling {@link
     * com.smartgwt.client.data.ResultSet#setCriteria ResultSet.setCriteria()}, but does not appear in
     * the UI.
     *
     * <p>Default value is false
     */
    public boolean hidden;

    /**
     * Whether this operator needs to be executed on the server side. <P> This implies that if a
     * {@link com.smartgwt.client.data.Criterion} using this operator is either introduced into {@link
     * com.smartgwt.client.data.AdvancedCriteria criteria} or is changed, the server will need to be
     * contacted to perform filtering.
     *
     * <p>Default value is false
     */
    public boolean requiresServer;

}
