/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.layout;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.drawing.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.*;
import com.smartgwt.client.util.workflow.*;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;

/**
 * Encapsulates state of a {@link com.smartgwt.client.widgets.layout.NavigationBar}'s view. A
 * <code>NavigationBarViewState</code> object is created to pass to {@link
 * com.smartgwt.client.widgets.layout.NavigationBar#setViewState NavigationBar.setViewState()} so that multiple properties
 * of the <code>NavigationBar</code> can be changed at once.
 */
@BeanFactory.FrameworkClass
public class NavigationBarViewState extends DataClass {

    public static NavigationBarViewState getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new NavigationBarViewState(jsObj);
    }


    public NavigationBarViewState(){
        
    }

    public NavigationBarViewState(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }


    // ********************* Properties / Attributes ***********************

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getAlwaysShowLeftButtonTitle
     * NavigationBar.alwaysShowLeftButtonTitle} setting. If unset, the <code>alwaysShowLeftButtonTitle</code> setting is not
     * changed.
     *
     * @param alwaysShowLeftButtonTitle  Default value is null
     */
    public void setAlwaysShowLeftButtonTitle(Boolean alwaysShowLeftButtonTitle) {
        if (readOnly) {
            ConfigUtil.warnOfPostConfigModification(NavigationBarViewState.class, "setAlwaysShowLeftButtonTitle", "Boolean");
        }
        setAttribute("alwaysShowLeftButtonTitle", alwaysShowLeftButtonTitle);
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getAlwaysShowLeftButtonTitle
     * NavigationBar.alwaysShowLeftButtonTitle} setting. If unset, the <code>alwaysShowLeftButtonTitle</code> setting is not
     * changed.
     *
     * @return Boolean
     */
    public Boolean getAlwaysShowLeftButtonTitle()  {
        return getAttributeAsBoolean("alwaysShowLeftButtonTitle", true);
    }
    

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getControls NavigationBar.controls} setting. If unset,
     * the <code>controls</code> array is not changed.
     *
     * @param controls  Default value is null
     */
    public void setControls(String... controls) {
        if (readOnly) {
            ConfigUtil.warnOfPostConfigModification(NavigationBarViewState.class, "setControls", "String...");
        }
        setAttribute("controls", controls);
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getControls NavigationBar.controls} setting. If unset,
     * the <code>controls</code> array is not changed.
     *
     * @return String...
     */
    public String[] getControls()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("controls"));
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getControls NavigationBar.controls} setting. If unset,
     * the <code>controls</code> array is not changed.
     *
     * @param controls  Default value is null
     */
    public void setControls(Canvas controls) {
        if (readOnly) {
            ConfigUtil.warnOfPostConfigModification(NavigationBarViewState.class, "setControls", "Canvas");
        }
        setAttribute("controls", controls == null ? null : controls.getOrCreateJsObj());
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getControls NavigationBar.controls} setting. If unset,
     * the <code>controls</code> array is not changed.
     *
     * @return Canvas
     */
    public Canvas getControlsAsCanvas()  {
        return (Canvas)Canvas.getByJSObject(getAttributeAsJavaScriptObject("controls"));
    }
    

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getLeftButtonTitle NavigationBar.leftButtonTitle}
     * setting. If unset, the <code>leftButtonTitle</code> is not changed.
     *
     * @param leftButtonTitle  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is null
     */
    public void setLeftButtonTitle(String leftButtonTitle) {
        if (readOnly) {
            ConfigUtil.warnOfPostConfigModification(NavigationBarViewState.class, "setLeftButtonTitle", "String");
        }
        setAttribute("leftButtonTitle", leftButtonTitle);
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getLeftButtonTitle NavigationBar.leftButtonTitle}
     * setting. If unset, the <code>leftButtonTitle</code> is not changed.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getLeftButtonTitle()  {
        return getAttributeAsString("leftButtonTitle");
    }
    

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getShortLeftButtonTitle
     * NavigationBar.shortLeftButtonTitle} setting. If unset, the <code>shortLeftButtonTitle</code> is not changed.
     *
     * @param shortLeftButtonTitle  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is null
     */
    public void setShortLeftButtonTitle(String shortLeftButtonTitle) {
        if (readOnly) {
            ConfigUtil.warnOfPostConfigModification(NavigationBarViewState.class, "setShortLeftButtonTitle", "String");
        }
        setAttribute("shortLeftButtonTitle", shortLeftButtonTitle);
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getShortLeftButtonTitle
     * NavigationBar.shortLeftButtonTitle} setting. If unset, the <code>shortLeftButtonTitle</code> is not changed.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getShortLeftButtonTitle()  {
        return getAttributeAsString("shortLeftButtonTitle");
    }
    

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getShowLeftButton NavigationBar.showLeftButton} setting.
     * If unset, the <code>showLeftButton</code> setting is not changed.
     *
     * @param showLeftButton  Default value is null
     */
    public void setShowLeftButton(Boolean showLeftButton) {
        if (readOnly) {
            ConfigUtil.warnOfPostConfigModification(NavigationBarViewState.class, "setShowLeftButton", "Boolean");
        }
        setAttribute("showLeftButton", showLeftButton);
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getShowLeftButton NavigationBar.showLeftButton} setting.
     * If unset, the <code>showLeftButton</code> setting is not changed.
     *
     * @return Boolean
     */
    public Boolean getShowLeftButton()  {
        return getAttributeAsBoolean("showLeftButton", true);
    }
    

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getTitle NavigationBar.title} setting. If unset, the
     * <code>title</code> is not changed.
     *
     * @param title  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is null
     */
    public void setTitle(String title) {
        if (readOnly) {
            ConfigUtil.warnOfPostConfigModification(NavigationBarViewState.class, "setTitle", "String");
        }
        setAttribute("title", title);
    }

    /**
     * The new {@link com.smartgwt.client.widgets.layout.NavigationBar#getTitle NavigationBar.title} setting. If unset, the
     * <code>title</code> is not changed.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getTitle()  {
        return getAttributeAsString("title");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************



    public void unsetShowLeftButton() {
        JSOHelper.deleteAttribute(jsObj, "showLeftButton");
    }

    public void unsetLeftButtonTitle() {
        JSOHelper.deleteAttribute(jsObj, "leftButtonTitle");
    }

    public void unsetShortLeftButtonTitle() {
        JSOHelper.deleteAttribute(jsObj, "shortLeftButtonTitle");
    }

    public void unsetAlwaysShowLeftButtonTitle() {
        JSOHelper.deleteAttribute(jsObj, "alwaysShowLeftButtonTitle");
    }

    public void unsetTitle() {
        JSOHelper.deleteAttribute(jsObj, "title");
    }

    public void unsetControls() {
        JSOHelper.deleteAttribute(jsObj, "controls");
    }

}



